/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.security.PublicKey;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.util.KeyPairUtil;
import org.junit.Assert;
import org.junit.Test;

public class KeyPairUtilTest {
    @Test
    public void testBase64UrlEncoding() {
        byte[] data = new byte[]{-7, 18, -1, -104, -87, 52, 25};
        Assert.assertEquals((Object)"-RL_mKk0GQ==", (Object)KeyPairUtil.base64UrlEncode((byte[])data));
    }

    @Test
    public void testHexEncoding() {
        byte[] data = new byte[]{-7, 18, -1, -104, -87, 52, 25};
        Assert.assertEquals((Object)"f912ff98a93419", (Object)KeyPairUtil.hexEncodeHashData((byte[])data));
    }

    @Test
    public void shouldStripPaddingFromEncodedKeyIdentifier() {
        PublicKey publicKey = KeyPairFactoryTest.TEST_KEY_PAIR.getPublic();
        String ski = KeyPairUtil.getEncodedKeyIdentifier((PublicKey)publicKey);
        Assert.assertTrue((String)"encoded key identifier should not contain padding character", (ski.indexOf(61) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)27L, (long)ski.length());
    }
}

