/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.security.PublicKey;
import net.ripe.rpki.commons.crypto.util.EncodedPublicKey;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EncodedPublicKeyTest {
    private static final PublicKey PUBLIC_KEY = KeyPairFactoryTest.TEST_KEY_PAIR.getPublic();
    public EncodedPublicKey subject;

    @Before
    public void setUp() {
        Assert.assertEquals((Object)"RSA", (Object)PUBLIC_KEY.getAlgorithm());
        this.subject = new EncodedPublicKey(PUBLIC_KEY.getEncoded());
    }

    @Test
    public void shouldReturnEncodedPart() {
        Assert.assertArrayEquals((byte[])PUBLIC_KEY.getEncoded(), (byte[])this.subject.getEncoded());
    }

    @Test
    public void shouldReturnFormat() {
        Assert.assertEquals((Object)PUBLIC_KEY.getFormat(), (Object)this.subject.getFormat());
        this.subject.getFormat();
    }

    @Test
    public void shouldReturnAlgorithm() {
        Assert.assertEquals((Object)PUBLIC_KEY.getAlgorithm(), (Object)this.subject.getAlgorithm());
    }
}

