/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.rfc3779;

import java.io.IOException;
import java.util.TreeMap;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionEncoder;
import net.ripe.rpki.commons.crypto.util.Asn1UtilTest;
import org.bouncycastle.asn1.ASN1Encodable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceExtensionEncoderTest {
    public static final Asn ASN_0 = Asn.parse((String)"AS0");
    public static final Asn ASN_127 = Asn.parse((String)"AS127");
    public static final Asn ASN_128 = Asn.parse((String)"AS128");
    public static final Asn ASN_412_233 = Asn.parse((String)"AS412.233");
    public static final Asn ASN_65535_65535 = Asn.parse((String)"AS65535.65535");
    public static final byte[] ENCODED_NULL = new byte[]{5, 0};
    public static final byte[] ENCODED_IPV4_0_0_0_0_0 = new byte[]{3, 1, 0};
    public static final byte[] ENCODED_IPV4_10_5_0_4_32 = new byte[]{3, 5, 0, 10, 5, 0, 4};
    public static final byte[] ENCODED_IPV4_10_5_0_0_23 = new byte[]{3, 4, 1, 10, 5, 0};
    public static final byte[] ENCODED_IPV4_128_5_0_4_32 = new byte[]{3, 5, 0, -128, 5, 0, 4};
    public static final byte[] ENCODED_IPV4_10_64_0_0_12 = new byte[]{3, 3, 4, 10, 64};
    public static final byte[] ENCODED_IPV4_10_64_0_0_20 = new byte[]{3, 4, 4, 10, 64, 0};
    public static final byte[] ENCODED_IPV6_2001_0_200_3_0_0_0_1_128 = new byte[]{3, 17, 0, 32, 1, 0, 0, 2, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 1};
    public static final byte[] ENCODED_IPV6_2001_0_200_39 = new byte[]{3, 6, 1, 32, 1, 0, 0, 2};
    public static final byte[] ENCODED_IPV4_RANGE_10_5_0_0_TO_10_5_1_255 = new byte[]{48, 11, 3, 3, 0, 10, 5, 3, 4, 1, 10, 5, 0};
    public static final byte[] ENCODED_IPV4_RANGE_10_5_4_0_TO_10_5_15_255 = new byte[]{48, 12, 3, 4, 2, 10, 5, 4, 3, 4, 4, 10, 5, 0};
    public static final byte[] ENCODED_IPV4_RANGE_128_5_4_0_TO_128_5_15_255 = new byte[]{48, 12, 3, 4, 2, -128, 5, 4, 3, 4, 4, -128, 5, 0};
    public static final byte[] ENCODED_IPV4_RANGE_0_0_0_0_TO_255_255_255_255 = new byte[]{48, 6, 3, 1, 0, 3, 1, 0};
    public static final byte[] ENCODED_IPV6_RANGE_2001_0_200__TO_2001_0_3FF_FFFF_FFFF_FFFF_FFFF_FFFF = new byte[]{48, 16, 3, 6, 1, 32, 1, 0, 0, 2, 3, 6, 2, 32, 1, 0, 0, 0};
    public static final byte[] ENCODED_IPV4_RESOURCES = new byte[]{48, 21, 48, 12, 3, 4, 2, 10, 5, 4, 3, 4, 4, 10, 5, 0, 3, 5, 0, -128, 5, 0, 4};
    public static final byte[] ENCODED_IPV4_ADDRESS_FAMILY_RESOURCES = new byte[]{48, 27, 4, 2, 0, 1, 48, 21, 48, 12, 3, 4, 2, 10, 5, 4, 3, 4, 4, 10, 5, 0, 3, 5, 0, -128, 5, 0, 4};
    public static final byte[] ENCODED_IPV4_MULTICAST_ADDRESS_FAMILY_RESOURCES = new byte[]{48, 28, 4, 3, 0, 1, 2, 48, 21, 48, 12, 3, 4, 2, 10, 5, 4, 3, 4, 4, 10, 5, 0, 3, 5, 0, -128, 5, 0, 4};
    public static final byte[] ENCODED_IP_ADDRESS_BLOCKS = new byte[]{48, 45, 48, 27, 4, 2, 0, 1, 48, 21, 48, 12, 3, 4, 2, 10, 5, 4, 3, 4, 4, 10, 5, 0, 3, 5, 0, -128, 5, 0, 4, 48, 14, 4, 2, 0, 2, 48, 8, 3, 6, 1, 32, 1, 0, 0, 2};
    public static final byte[] ENCODED_IP_ADDRESS_BLOCKS_EXTENSION = new byte[]{4, 47, 48, 45, 48, 27, 4, 2, 0, 1, 48, 21, 48, 12, 3, 4, 2, 10, 5, 4, 3, 4, 4, 10, 5, 0, 3, 5, 0, -128, 5, 0, 4, 48, 14, 4, 2, 0, 2, 48, 8, 3, 6, 1, 32, 1, 0, 0, 2};
    public static final byte[] ENCODED_IPV4_ONLY_ADDRESS_BLOCKS = new byte[]{48, 29, 48, 27, 4, 2, 0, 1, 48, 21, 48, 12, 3, 4, 2, 10, 5, 4, 3, 4, 4, 10, 5, 0, 3, 5, 0, -128, 5, 0, 4};
    public static final byte[] ENCODED_IPV4_ONLY_INHERITED = new byte[]{4, 10, 48, 8, 48, 6, 4, 2, 0, 1, 5, 0};
    public static final byte[] ENCODED_IPV4_AND_IPV6_INHERITED = new byte[]{4, 18, 48, 16, 48, 6, 4, 2, 0, 1, 5, 0, 48, 6, 4, 2, 0, 2, 5, 0};
    public static final byte[] ENCODED_ASN_0 = new byte[]{2, 1, 0};
    public static final byte[] ENCODED_ASN_127 = new byte[]{2, 1, 127};
    public static final byte[] ENCODED_ASN_128 = new byte[]{2, 2, 0, -128};
    public static final byte[] ENCODED_ASN_412_233 = new byte[]{2, 4, 1, -100, 0, -23};
    public static final byte[] ENCODED_ASN_65535_65535 = new byte[]{2, 5, 0, -1, -1, -1, -1};
    public static final byte[] ENCODED_ASN_127_TO_128 = new byte[]{48, 7, 2, 1, 127, 2, 2, 0, -128};
    public static final byte[] ENCODED_ASN_0_TO_65535_65535 = new byte[]{48, 10, 2, 1, 0, 2, 5, 0, -1, -1, -1, -1};
    public static final byte[] ENCODED_AS_IDS_OR_RANGES = new byte[]{48, 15, 48, 7, 2, 1, 127, 2, 2, 0, -128, 2, 4, 1, -100, 0, -23};
    public static final byte[] ENCODED_AS_IDENTIFIERS = new byte[]{48, 19, -96, 17, 48, 15, 48, 7, 2, 1, 127, 2, 2, 0, -128, 2, 4, 1, -100, 0, -23};
    public static final byte[] ENCODED_AS_IDENTIFIERS_EXTENSION = new byte[]{4, 21, 48, 19, -96, 17, 48, 15, 48, 7, 2, 1, 127, 2, 2, 0, -128, 2, 4, 1, -100, 0, -23};
    public static final byte[] ENCODED_AS_IDENTIFIERS_INHERITED = new byte[]{4, 6, 48, 4, -96, 2, 5, 0};
    public static final byte[] RFC3779_APPENDIX_B_EXAMPLE_1 = new byte[]{48, 53, 48, 43, 4, 3, 0, 1, 1, 48, 36, 3, 4, 4, 10, 0, 32, 3, 4, 0, 10, 0, 64, 3, 3, 0, 10, 1, 48, 12, 3, 4, 4, 10, 2, 48, 3, 4, 0, 10, 2, 64, 3, 3, 0, 10, 3, 48, 6, 4, 2, 0, 2, 5, 0};
    public static final byte[] RFC3779_APPENDIX_B_EXAMPLE_2 = new byte[]{48, 44, 48, 16, 4, 3, 0, 1, 1, 48, 9, 3, 2, 0, 10, 3, 3, 4, -80, 16, 48, 7, 4, 3, 0, 1, 2, 5, 0, 48, 15, 4, 2, 0, 2, 48, 9, 3, 7, 0, 32, 1, 0, 0, 0, 2};
    public static final byte[] RFC3779_APPENDIX_C_EXAMPLE = new byte[]{48, 26, -96, 20, 48, 18, 2, 2, 0, -121, 48, 8, 2, 2, 11, -72, 2, 2, 15, -97, 2, 2, 19, -119, -95, 2, 5, 0};
    private ResourceExtensionEncoder subject;

    @Before
    public void setUp() {
        this.subject = new ResourceExtensionEncoder();
    }

    @Test
    public void shouldEncodeIpv4Range() {
        Asn1UtilTest.assertEncoded(ENCODED_IPV4_RANGE_10_5_0_0_TO_10_5_1_255, (ASN1Encodable)this.subject.ipRangeToDer(IpRange.parse((String)"10.5.0.0-10.5.1.255")));
        Asn1UtilTest.assertEncoded(ENCODED_IPV4_RANGE_10_5_4_0_TO_10_5_15_255, (ASN1Encodable)this.subject.ipRangeToDer(IpRange.parse((String)"10.5.4.0-10.5.15.255")));
        Asn1UtilTest.assertEncoded(ENCODED_IPV4_RANGE_128_5_4_0_TO_128_5_15_255, (ASN1Encodable)this.subject.ipRangeToDer(IpRange.parse((String)"128.5.4.0-128.5.15.255")));
        Asn1UtilTest.assertEncoded(ENCODED_IPV4_RANGE_0_0_0_0_TO_255_255_255_255, (ASN1Encodable)this.subject.ipRangeToDer(IpRange.parse((String)"0.0.0.0-255.255.255.255")));
    }

    @Test
    public void shouldEncodeIpv6Range() {
        Asn1UtilTest.assertEncoded(ENCODED_IPV6_RANGE_2001_0_200__TO_2001_0_3FF_FFFF_FFFF_FFFF_FFFF_FFFF, (ASN1Encodable)this.subject.ipRangeToDer(IpRange.parse((String)"2001:0:200::-2001:0:3ff:ffff:ffff:ffff:ffff:ffff")));
    }

    @Test
    public void shouldEncodeIpAddressOrRange() {
        Asn1UtilTest.assertEncoded(ENCODED_IPV4_10_5_0_0_23, this.subject.ipAddressOrRangeToDer(IpRange.parse((String)"10.5.0.0/23")));
        Asn1UtilTest.assertEncoded(ENCODED_IPV4_RANGE_10_5_4_0_TO_10_5_15_255, this.subject.ipAddressOrRangeToDer(IpRange.parse((String)"10.5.4.0-10.5.15.255")));
    }

    @Test
    public void shouldEncodeIpAddressChoice() {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{IpRange.parse((String)"128.5.0.4/32"), IpRange.parse((String)"10.5.4.0-10.5.15.255")});
        Asn1UtilTest.assertEncoded(ENCODED_IPV4_RESOURCES, this.subject.ipAddressChoiceToDer(IpResourceType.IPv4, resources));
        Asn1UtilTest.assertEncoded(ENCODED_NULL, this.subject.ipAddressChoiceToDer(IpResourceType.IPv4, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectEmptyIpAddressesOrRanges() {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{IpRange.parse((String)"128.5.0.4/30")});
        this.subject.ipAddressChoiceToDer(IpResourceType.IPv6, resources);
    }

    @Test
    public void shouldEncodeIpAddressFamily() {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{IpRange.parse((String)"128.5.0.4/32"), IpRange.parse((String)"10.5.4.0-10.5.15.255")});
        Asn1UtilTest.assertEncoded(ENCODED_IPV4_ADDRESS_FAMILY_RESOURCES, (ASN1Encodable)this.subject.ipAddressFamilyToDer(AddressFamily.IPV4, resources));
    }

    @Test
    public void shouldEncodeIpAddressFamilyWithSafi() {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{IpRange.parse((String)"128.5.0.4/32"), IpRange.parse((String)"10.5.4.0-10.5.15.255")});
        Asn1UtilTest.assertEncoded(ENCODED_IPV4_MULTICAST_ADDRESS_FAMILY_RESOURCES, (ASN1Encodable)this.subject.ipAddressFamilyToDer(AddressFamily.IPV4.withSubsequentAddressFamilyIdentifier(Integer.valueOf(2)), resources));
    }

    @Test
    public void shouldEncodeIpAddressBlocks() throws IOException {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{IpRange.parse((String)"128.5.0.4/32"), IpRange.parse((String)"10.5.4.0-10.5.15.255"), IpRange.parse((String)"2001:0:200::-2001:0:3ff:ffff:ffff:ffff:ffff:ffff")});
        Assert.assertArrayEquals((byte[])ENCODED_IP_ADDRESS_BLOCKS, (byte[])this.subject.encodeIpAddressBlocks(false, false, resources).getEncoded());
        resources = new IpResourceSet(new IpResource[]{IpRange.parse((String)"128.5.0.4/32"), IpRange.parse((String)"10.5.4.0-10.5.15.255")});
        Assert.assertArrayEquals((byte[])ENCODED_IPV4_ONLY_ADDRESS_BLOCKS, (byte[])this.subject.encodeIpAddressBlocks(false, false, resources).getEncoded());
    }

    @Test
    public void shouldNotEncodeEmptyIpAddressBlocksExtension() {
        Assert.assertNull((Object)this.subject.encodeIpAddressBlocks(false, false, new IpResourceSet()));
    }

    @Test
    public void shouldEncodeAsn() {
        Asn1UtilTest.assertEncoded(ENCODED_ASN_0, (ASN1Encodable)this.subject.asIdToDer(ASN_0));
        Asn1UtilTest.assertEncoded(ENCODED_ASN_127, (ASN1Encodable)this.subject.asIdToDer(ASN_127));
        Asn1UtilTest.assertEncoded(ENCODED_ASN_128, (ASN1Encodable)this.subject.asIdToDer(ASN_128));
        Asn1UtilTest.assertEncoded(ENCODED_ASN_412_233, (ASN1Encodable)this.subject.asIdToDer(ASN_412_233));
        Asn1UtilTest.assertEncoded(ENCODED_ASN_65535_65535, (ASN1Encodable)this.subject.asIdToDer(ASN_65535_65535));
    }

    @Test
    public void shouldEncodeAsRange() {
        Asn1UtilTest.assertEncoded(ENCODED_ASN_127_TO_128, (ASN1Encodable)this.subject.asRangeToDer(ASN_127.upTo((UniqueIpResource)ASN_128)));
        Asn1UtilTest.assertEncoded(ENCODED_ASN_0_TO_65535_65535, (ASN1Encodable)this.subject.asRangeToDer(ASN_0.upTo((UniqueIpResource)ASN_65535_65535)));
    }

    @Test
    public void shouldEncodeAsIdOrRange() {
        Asn1UtilTest.assertEncoded(ENCODED_ASN_127, this.subject.asIdOrRangeToDer(ASN_127.upTo((UniqueIpResource)ASN_127)));
        Asn1UtilTest.assertEncoded(ENCODED_ASN_127_TO_128, this.subject.asIdOrRangeToDer(ASN_127.upTo((UniqueIpResource)ASN_128)));
    }

    @Test
    public void shouldEncodeAsIdsOrRanges() {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{ASN_412_233, ASN_127.upTo((UniqueIpResource)ASN_128)});
        Asn1UtilTest.assertEncoded(ENCODED_AS_IDS_OR_RANGES, (ASN1Encodable)this.subject.asIdsOrRangesToDer(resources));
    }

    @Test
    public void shouldEncodeAsIdentifierChoice() {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{ASN_412_233, ASN_127.upTo((UniqueIpResource)ASN_128)});
        Asn1UtilTest.assertEncoded(ENCODED_NULL, this.subject.asIdentifierChoiceToDer(true, resources));
        Asn1UtilTest.assertEncoded(ENCODED_AS_IDS_OR_RANGES, this.subject.asIdentifierChoiceToDer(false, resources));
    }

    @Test
    public void shouldEncodeAsIdentifiers() throws IOException {
        IpResourceSet resources = new IpResourceSet(new IpResource[]{ASN_412_233, ASN_127.upTo((UniqueIpResource)ASN_128)});
        Assert.assertArrayEquals((byte[])ENCODED_AS_IDENTIFIERS, (byte[])this.subject.encodeAsIdentifiers(false, resources).getEncoded());
    }

    @Test
    public void shouldNotEncodeEmptyAsIdentifiersExtension() {
        Assert.assertNull((Object)this.subject.encodeAsIdentifiers(false, IpResourceSet.parse((String)"10.0.0.0/8")));
    }

    @Test
    public void shouldEncodeRfc3779AppendixBFirstExample() {
        TreeMap<AddressFamily, IpResourceSet> resources = new TreeMap<AddressFamily, IpResourceSet>();
        resources.put(AddressFamily.IPV4.withSubsequentAddressFamilyIdentifier(Integer.valueOf(1)), IpResourceSet.parse((String)"10.0.32.0/20, 10.0.64.0/24, 10.1.0.0/16, 10.2.48.0/20, 10.2.64.0/24, 10.3.0.0/16"));
        resources.put(AddressFamily.IPV6, null);
        Asn1UtilTest.assertEncoded(RFC3779_APPENDIX_B_EXAMPLE_1, (ASN1Encodable)this.subject.ipAddressBlocksToDer(resources));
    }

    @Test
    public void shouldEncodeRfc3779AppendixBSecondExample() {
        TreeMap<AddressFamily, IpResourceSet> resources = new TreeMap<AddressFamily, IpResourceSet>();
        resources.put(AddressFamily.IPV6, IpResourceSet.parse((String)"2001:0:2::/48"));
        resources.put(AddressFamily.IPV4.withSubsequentAddressFamilyIdentifier(Integer.valueOf(1)), IpResourceSet.parse((String)"10.0.0.0/8,176.16.0.0/12"));
        resources.put(AddressFamily.IPV4.withSubsequentAddressFamilyIdentifier(Integer.valueOf(2)), null);
        Asn1UtilTest.assertEncoded(RFC3779_APPENDIX_B_EXAMPLE_2, (ASN1Encodable)this.subject.ipAddressBlocksToDer(resources));
    }

    @Test
    public void shouldEncodeRfc3779AppendixCExample() {
        IpResourceSet asnResources = IpResourceSet.parse((String)"AS135, AS3000-AS3999, AS5001");
        Asn1UtilTest.assertEncoded(RFC3779_APPENDIX_C_EXAMPLE, (ASN1Encodable)this.subject.asIdentifiersToDer(false, asnResources, true, null));
    }
}

