/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.rfc3779;

import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import org.bouncycastle.asn1.ASN1Encodable;
import org.junit.Assert;
import org.junit.Test;

public class AddressFamilyTest {
    private static final AddressFamily IPV6_5 = AddressFamily.IPV6.withSubsequentAddressFamilyIdentifier(Integer.valueOf(5));
    private static final AddressFamily IPV4_2 = AddressFamily.IPV4.withSubsequentAddressFamilyIdentifier(Integer.valueOf(2));
    private static final AddressFamily IPV4_1 = AddressFamily.IPV4.withSubsequentAddressFamilyIdentifier(Integer.valueOf(1));
    private static final AddressFamily IPV6_2 = AddressFamily.IPV6.withSubsequentAddressFamilyIdentifier(Integer.valueOf(2));

    @Test
    public void shouldBeEqualBasedOnAfiAndSafi() {
        Assert.assertEquals((Object)AddressFamily.IPV4, (Object)AddressFamily.IPV4);
        Assert.assertEquals((long)0L, (long)AddressFamily.IPV4.compareTo(AddressFamily.IPV4));
        Assert.assertEquals((Object)AddressFamily.IPV6, (Object)AddressFamily.IPV6);
        Assert.assertEquals((long)0L, (long)AddressFamily.IPV6.compareTo(AddressFamily.IPV6));
        Assert.assertEquals((Object)IPV6_2, (Object)IPV6_2);
        Assert.assertEquals((long)0L, (long)IPV6_2.compareTo(IPV6_2));
        Assert.assertEquals((Object)AddressFamily.IPV6, (Object)IPV6_2.withoutSubsequentAddressFamilyIdentifier());
    }

    @Test
    public void shouldOrderIpv4BeforeIpv6() {
        Assert.assertTrue((AddressFamily.IPV4.compareTo(AddressFamily.IPV6) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((AddressFamily.IPV6.compareTo(AddressFamily.IPV4) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldOrderLowerSafiBeforeHigherSafi() {
        Assert.assertTrue((IPV4_1.compareTo(IPV4_2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((IPV6_5.compareTo(IPV6_2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldOrderAddressFamilyWithoutSafiBeforeAddressFamilyWithSafi() {
        Assert.assertTrue((AddressFamily.IPV4.compareTo(IPV4_2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((IPV4_2.compareTo(AddressFamily.IPV4) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldConvertToDerOctetString() {
        byte[] encodedIpv4 = new byte[]{0, 1};
        Assert.assertArrayEquals((byte[])encodedIpv4, (byte[])AddressFamily.IPV4.toDer().getOctets());
        byte[] encodedIpv4Multicast = new byte[]{0, 1, 2};
        Assert.assertArrayEquals((byte[])encodedIpv4Multicast, (byte[])IPV4_2.toDer().getOctets());
        byte[] encodedIpv6 = new byte[]{0, 2};
        Assert.assertArrayEquals((byte[])encodedIpv6, (byte[])AddressFamily.IPV6.toDer().getOctets());
        byte[] encoded = new byte[]{-128, -16, -120};
        Assert.assertArrayEquals((byte[])encoded, (byte[])new AddressFamily(33008, Integer.valueOf(136)).toDer().getOctets());
    }

    @Test
    public void shouldConstructFromDer() {
        byte[] encodedIpv4 = new byte[]{4, 2, 0, 1};
        Assert.assertEquals((Object)AddressFamily.IPV4, (Object)AddressFamily.fromDer((ASN1Encodable)Asn1Util.decode((byte[])encodedIpv4)));
        byte[] encodedIpv4Multicast = new byte[]{4, 3, 0, 1, 2};
        Assert.assertEquals((Object)IPV4_2, (Object)AddressFamily.fromDer((ASN1Encodable)Asn1Util.decode((byte[])encodedIpv4Multicast)));
        byte[] encodedIpv6 = new byte[]{4, 2, 0, 2};
        Assert.assertEquals((Object)AddressFamily.IPV6, (Object)AddressFamily.fromDer((ASN1Encodable)Asn1Util.decode((byte[])encodedIpv6)));
        byte[] encoded = new byte[]{4, 3, -128, -16, -120};
        Assert.assertEquals((Object)new AddressFamily(33008, Integer.valueOf(136)), (Object)AddressFamily.fromDer((ASN1Encodable)Asn1Util.decode((byte[])encoded)));
    }

    @Test
    public void shouldConvertToIpResourceType() {
        Assert.assertEquals((Object)IpResourceType.IPv4, (Object)AddressFamily.IPV4.toIpResourceType());
        Assert.assertEquals((Object)IpResourceType.IPv6, (Object)AddressFamily.IPV6.toIpResourceType());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldFailToConvertToIpResourceTypeForUnknownAfi() {
        new AddressFamily(25).toIpResourceType();
    }
}

