/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import java.util.ArrayList;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsBuilder;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsObjectMother;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=JUnitQuickcheck.class)
public class RoaCMSBuilderPropertyTest {
    @Property
    public void buildEncodedParseCheck(@InRange(min="1", max="4294967295") @InRange(min="1", max="4294967295") long asNum, @InRange(min="12", max="24") @InRange(min="12", max="24") Integer maxLength) {
        RoaPrefix TEST_IPV4_PREFIX_1 = new RoaPrefix(IpRange.parse((String)"10.64.0.0/12"), maxLength);
        ArrayList<RoaPrefix> prefixes = new ArrayList<RoaPrefix>();
        prefixes.add(TEST_IPV4_PREFIX_1);
        RoaCmsBuilder builder = new RoaCmsBuilder();
        builder.withSignatureProvider("SunRsaSign");
        builder.withCertificate(RoaCmsTest.createCertificate(prefixes, RoaCmsObjectMother.TEST_KEY_PAIR));
        Asn asn = new Asn(asNum);
        builder.withAsn(asn);
        builder.withPrefixes(prefixes);
        RoaCms roaCms = builder.build(RoaCmsObjectMother.TEST_KEY_PAIR.getPrivate());
        RoaCmsParser roaParser = new RoaCmsParser();
        roaParser.parse("test.roa", roaCms.getEncoded());
        RoaCms parsedRoaCms = roaParser.getRoaCms();
        Assert.assertTrue((boolean)parsedRoaCms.getPrefixes().equals(prefixes));
        Assert.assertTrue((boolean)parsedRoaCms.getAsn().equals((Object)asn));
    }
}

