/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.aspa;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.ripe.ipresource.Asn;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCms;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCmsParser;
import net.ripe.rpki.commons.crypto.cms.aspa.ProviderAS;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class AspaCmsParserTest {
    AspaCmsParserTest() {
    }

    @Test
    void should_parse_aspa_rpkimancer() throws IOException {
        AspaCms aspa = this.parseValidAspa("interop/aspa/aspa-rpkimancer.asa");
        AssertionsForInterfaceTypes.assertThat((Comparable)aspa.getCustomerAsn()).isEqualTo((Object)Asn.parse((String)"AS65000"));
        AssertionsForInterfaceTypes.assertThat((Collection)aspa.getProviderASSet()).containsExactly((Object[])new ProviderAS[]{new ProviderAS(Asn.parse((String)"AS65001"), Optional.empty()), new ProviderAS(Asn.parse((String)"AS65002"), Optional.of(AddressFamily.IPV4))});
    }

    @Test
    void should_parse_aspa_krill() throws IOException {
        AspaCms aspa = this.parseValidAspa("interop/aspa/AS211321.asa");
        AssertionsForInterfaceTypes.assertThat((Comparable)aspa.getCustomerAsn()).isEqualTo((Object)Asn.parse((String)"AS211321"));
        AssertionsForInterfaceTypes.assertThat((Collection)aspa.getProviderASSet()).containsExactly((Object[])new ProviderAS[]{new ProviderAS(Asn.parse((String)"AS65000"), Optional.empty()), new ProviderAS(Asn.parse((String)"AS65001"), Optional.of(AddressFamily.IPV4)), new ProviderAS(Asn.parse((String)"AS65002"), Optional.of(AddressFamily.IPV6))});
    }

    private AspaCms parseValidAspa(String path) throws IOException {
        byte[] bytes = Resources.toByteArray((URL)Resources.getResource((String)path));
        ValidationResult result = ValidationResult.withLocation((String)path);
        AspaCmsParser parser = new AspaCmsParser();
        parser.parse(result, bytes);
        ((ListAssert)AssertionsForInterfaceTypes.assertThat((List)result.getFailuresForAllLocations()).withFailMessage(() -> "" + result.getFailuresForAllLocations())).isEmpty();
        AspaCms aspa = parser.getAspa();
        return aspa;
    }

    @Test
    void parseAspa_wrong_file_type() throws IOException {
        AspaCmsParser parser = new AspaCmsParser();
        ValidationResult result = ValidationResult.withLocation((String)"goodROAASIDZero.roa");
        parser.parse(result, Resources.toByteArray((URL)Resources.getResource((String)"conformance/root/goodROAASIDZero.roa")));
        AssertionsForInterfaceTypes.assertThat((boolean)result.hasFailures()).isTrue();
        AssertionsForInterfaceTypes.assertThat((List)result.getFailuresForAllLocations()).anyMatch(check -> "aspa.content.type".equals(check.getKey()));
    }
}

