/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons;

import java.util.Date;
import net.ripe.rpki.commons.FixedDateRule;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.util.UTC;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ValidityPeriodTest {
    @Rule
    public FixedDateRule fixedDateRule = new FixedDateRule(new DateTime(2008, 4, 5, 0, 0, 0, 0, DateTimeZone.UTC));

    @Test
    public void testWrongValidityPeriod() {
        try {
            DateTime now = UTC.dateTime();
            new ValidityPeriod((ReadableInstant)now, (ReadableInstant)now.minus((ReadablePeriod)Period.millis((int)1)));
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void singleInstantShouldBeOK() {
        DateTime now = UTC.dateTime();
        new ValidityPeriod((ReadableInstant)now, (ReadableInstant)now);
    }

    @Test
    public void shouldAllowUnspecifiedNotValidAfterDate() {
        ValidityPeriod closed = new ValidityPeriod(this.date(2008, 1, 1), this.date(2008, 12, 1));
        ValidityPeriod open = new ValidityPeriod(this.date(2008, 1, 1), null);
        Assert.assertTrue((boolean)closed.isClosed());
        Assert.assertFalse((boolean)open.isClosed());
        Assert.assertTrue((String)"open should contain closed", (boolean)open.contains(closed));
        Assert.assertFalse((String)"closed should not contain open", (boolean)closed.contains(open));
        Assert.assertTrue((boolean)open.isValidAt(this.date(2008, 1, 1)));
        Assert.assertTrue((boolean)open.isValidAt(this.date(2023, 1, 1)));
        Assert.assertFalse((boolean)open.isValidAt(this.date(2003, 1, 1)));
    }

    @Test
    public void shouldAllowUnspecifiedNotBeforeAfterDate() {
        ValidityPeriod closed = new ValidityPeriod(this.date(2008, 1, 1), this.date(2008, 12, 1));
        ValidityPeriod open = new ValidityPeriod(null, this.date(2008, 12, 1));
        Assert.assertTrue((boolean)closed.isClosed());
        Assert.assertFalse((boolean)open.isClosed());
        Assert.assertTrue((String)"open should contain closed", (boolean)open.contains(closed));
        Assert.assertFalse((String)"closed should not contain open", (boolean)closed.contains(open));
        Assert.assertTrue((boolean)open.isValidAt(this.date(2008, 1, 1)));
        Assert.assertFalse((boolean)open.isValidAt(this.date(2023, 1, 1)));
        Assert.assertTrue((boolean)open.isValidAt(this.date(2003, 1, 1)));
    }

    @Test
    public void shouldSupportJavaUtilDate() {
        ValidityPeriod subject = new ValidityPeriod(new Date(), new Date());
        Assert.assertNotNull((Object)subject.getNotValidBefore());
        Assert.assertNotNull((Object)subject.getNotValidAfter());
        subject = new ValidityPeriod(new Date(), null);
        Assert.assertNotNull((Object)subject.getNotValidBefore());
        Assert.assertNull((Object)subject.getNotValidAfter());
        subject = new ValidityPeriod(null, new Date());
        Assert.assertNull((Object)subject.getNotValidBefore());
        Assert.assertNotNull((Object)subject.getNotValidAfter());
    }

    @Test
    public void shouldTruncateToOneSecondAccuracy() {
        ValidityPeriod subject = new ValidityPeriod((ReadableInstant)new DateTime(2008, 3, 30, 15, 44, 58, 943, DateTimeZone.UTC), (ReadableInstant)new DateTime(2008, 5, 30, 15, 44, 23, 123, DateTimeZone.UTC));
        Assert.assertEquals((Object)new DateTime(2008, 3, 30, 15, 44, 58, 0, DateTimeZone.UTC), (Object)subject.getNotValidBefore());
        Assert.assertEquals((Object)new DateTime(2008, 5, 30, 15, 44, 23, 0, DateTimeZone.UTC), (Object)subject.getNotValidAfter());
    }

    @Test
    public void shouldSupportIntersection() {
        DateTime t1 = new DateTime(2008, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
        DateTime t2 = new DateTime(2008, 2, 1, 0, 0, 0, 0, DateTimeZone.UTC);
        DateTime t3 = new DateTime(2008, 11, 1, 0, 0, 0, 0, DateTimeZone.UTC);
        DateTime t4 = new DateTime(2008, 12, 1, 0, 0, 0, 0, DateTimeZone.UTC);
        Assert.assertEquals(null, (Object)new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t2).intersectedWith(new ValidityPeriod((ReadableInstant)t3, (ReadableInstant)t4)));
        Assert.assertEquals((Object)new ValidityPeriod(), (Object)new ValidityPeriod().intersectedWith(new ValidityPeriod()));
        Assert.assertEquals((Object)new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t3), (Object)new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t3).intersectedWith(new ValidityPeriod()));
        Assert.assertEquals((Object)new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t3), (Object)new ValidityPeriod().intersectedWith(new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t3)));
        Assert.assertEquals((Object)new ValidityPeriod((ReadableInstant)t2, (ReadableInstant)t3), (Object)new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t3).intersectedWith(new ValidityPeriod((ReadableInstant)t2, (ReadableInstant)t4)));
        Assert.assertEquals((Object)new ValidityPeriod((ReadableInstant)t2, (ReadableInstant)t3), (Object)new ValidityPeriod((ReadableInstant)t2, (ReadableInstant)t4).intersectedWith(new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t3)));
        Assert.assertEquals((Object)new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t3), (Object)new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t4).intersectedWith(new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t3)));
        Assert.assertEquals((Object)new ValidityPeriod((ReadableInstant)t2, (ReadableInstant)t4), (Object)new ValidityPeriod((ReadableInstant)t2, (ReadableInstant)t4).intersectedWith(new ValidityPeriod((ReadableInstant)t1, (ReadableInstant)t4)));
    }

    @Test
    public void sameStartingInstantShouldBeValid() {
        ValidityPeriod validityPeriod = new ValidityPeriod(this.date(2008, 1, 1), this.date(2009, 1, 1));
        Assert.assertTrue((boolean)validityPeriod.isValidAt(this.date(2008, 1, 1)));
    }

    @Test
    public void sameEndingInstantShouldBeValid() {
        ValidityPeriod validityPeriod = new ValidityPeriod(this.date(2008, 1, 1), this.date(2009, 1, 1));
        Assert.assertTrue((boolean)validityPeriod.isValidAt(this.date(2009, 1, 1)));
    }

    @Test
    public void shouldBeValidWithinTheValidityPeriod() {
        ValidityPeriod validityPeriod = new ValidityPeriod(this.date(2008, 1, 1), this.date(2009, 1, 1));
        Assert.assertTrue((boolean)validityPeriod.isValidNow());
    }

    @Test
    public void shouldBeInvalidOutsideTheValidityPeriod() {
        ValidityPeriod validityPeriod = new ValidityPeriod(this.date(2007, 1, 1), this.date(2008, 1, 1));
        Assert.assertTrue((boolean)validityPeriod.isExpiredNow());
        Assert.assertTrue((boolean)validityPeriod.isExpiredAt(this.date(2020, 1, 1)));
    }

    @Test
    public void shouldNeverBeExpiredIfNotValidAfterIsNotDefined() {
        ValidityPeriod validityPeriod = new ValidityPeriod(this.date(2007, 1, 1), null);
        Assert.assertFalse((boolean)validityPeriod.isExpiredAt(this.date(1920, 1, 1)));
        Assert.assertFalse((boolean)validityPeriod.isExpiredAt(this.date(2020, 1, 1)));
    }

    @Test
    public void truncatedMillisDates() {
        long instant = 1502895557772L;
        ValidityPeriod validityPeriod = new ValidityPeriod(new Date(instant), new Date(instant));
        Assert.assertEquals((long)validityPeriod.getNotValidBefore().getMillisOfSecond(), (long)0L);
        Assert.assertEquals((long)validityPeriod.getNotValidAfter().getMillisOfSecond(), (long)0L);
    }

    @Test
    public void truncatedMillisDateTimes() {
        long instant = 1502895557772L;
        ValidityPeriod validityPeriod = new ValidityPeriod((ReadableInstant)UTC.dateTime((Object)instant), (ReadableInstant)UTC.dateTime((Object)instant));
        Assert.assertEquals((long)validityPeriod.getNotValidBefore().getMillisOfSecond(), (long)0L);
        Assert.assertEquals((long)validityPeriod.getNotValidAfter().getMillisOfSecond(), (long)0L);
    }

    private ReadableInstant date(int year, int month, int day) {
        return new LocalDate(year, month, day).toDateTimeAtStartOfDay(DateTimeZone.UTC);
    }
}

