/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.objectvalidators;

import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.X509CertificateParentChildValidator;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateValidator;

public class X509ResourceCertificateParentChildValidator
extends X509CertificateParentChildValidator<X509ResourceCertificate>
implements X509ResourceCertificateValidator {
    private IpResourceSet resources;

    public X509ResourceCertificateParentChildValidator(ValidationOptions options, ValidationResult result, X509ResourceCertificate parent, X509Crl crl, IpResourceSet resources) {
        super(options, result, parent, crl);
        this.resources = resources;
    }

    @Override
    public void validate(String location, X509ResourceCertificate certificate) {
        super.validate(location, certificate);
        this.verifyResources();
    }

    private void verifyResources() {
        ValidationResult result = this.getValidationResult();
        X509ResourceCertificate child = (X509ResourceCertificate)this.getChild();
        IpResourceSet childResourceSet = child.deriveResources(this.resources);
        if (child.isRoot()) {
            result.rejectIfTrue(child.isResourceSetInherited(), "cert.root.resource.uses.inherit", new String[0]);
        } else if (!this.resources.contains(childResourceSet)) {
            IpResourceSet overclaiming = new IpResourceSet(childResourceSet);
            overclaiming.removeAll(this.resources);
            result.rejectIfFalse(overclaiming.isEmpty(), "cert.resource.range.is.valid", overclaiming.toString());
        }
    }
}

