/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.security.PublicKey;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateParser;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class X509RouterCertificateParser
extends X509CertificateParser<X509RouterCertificate> {
    @Override
    public X509RouterCertificate getCertificate() {
        if (!this.isSuccess()) {
            throw new IllegalArgumentException("Router certificate validation failed");
        }
        return new X509RouterCertificate(this.getX509Certificate());
    }

    @Override
    protected void validatePublicKey() {
        PublicKey publicKey = this.certificate.getPublicKey();
        if (this.isRsaPk(publicKey)) {
            super.validateRsaPk();
        } else if (this.isEcPk(publicKey)) {
            this.validateEcPk();
        } else {
            this.result.error("cert.public.key.algorithm", publicKey.getAlgorithm());
        }
    }

    @Override
    protected void doTypeSpecificValidation() {
        this.result.rejectIfFalse(this.isBgpSecExtensionPresent(), "cert.bgpsec.ext.present", new String[0]);
        X509CertificateInformationAccessDescriptor[] sia = X509CertificateUtil.getSubjectInformationAccess(this.certificate);
        this.result.rejectIfTrue(sia != null && sia.length > 0, "cert.sia.present", new String[0]);
        this.result.rejectIfTrue(this.isIpResourceExtensionPresent(), "cert.ip.resource.present", new String[0]);
        this.result.rejectIfFalse(this.isAsResourceExtensionPresent(), "cert.as.resource.present", new String[0]);
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)this.certificate.getPublicKey().getEncoded());
        this.result.rejectIfTrue(subjectPublicKeyInfo == null, "cert.subj.pk.not.present", new String[0]);
    }
}

