/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.crl;

import com.google.common.io.Closer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509CrlException;
import net.ripe.rpki.commons.crypto.crl.X509CrlValidator;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.util.EqualsSupport;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import org.apache.commons.lang.Validate;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class X509Crl
implements CertificateRepositoryObject {
    private static final long serialVersionUID = 1L;
    private final byte[] encoded;
    private transient X509CRL crl;

    public X509Crl(byte[] encoded) {
        Validate.notNull((Object)encoded);
        this.encoded = encoded;
    }

    public X509Crl(X509CRL crl) {
        Validate.notNull((Object)crl);
        try {
            this.crl = crl;
            this.encoded = crl.getEncoded();
        }
        catch (CRLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }

    public X509CRL getCrl() {
        if (this.crl == null) {
            this.crl = X509Crl.makeX509CRLFromEncoded(this.encoded);
        }
        return this.crl;
    }

    public static X509Crl parseDerEncoded(byte[] encoded, ValidationResult validationResult) {
        try {
            X509Crl crl = new X509Crl(X509Crl.makeX509CRLFromEncoded(encoded));
            validationResult.pass("crl.parsed", new String[0]);
            return crl;
        }
        catch (IllegalArgumentException e) {
            validationResult.error("crl.parsed", new String[0]);
            return null;
        }
    }

    private static X509CRL makeX509CRLFromEncoded(byte[] encoded) {
        X509CRL crl;
        block9: {
            if (null != encoded) {
                try (Closer closer = Closer.create();){
                    ByteArrayInputStream in = new ByteArrayInputStream(encoded);
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    crl = (X509CRL)factory.generateCRL(in);
                    break block9;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error managing CRL I/O stream", e);
                }
            }
            crl = null;
        }
        return crl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.encoded);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509Crl other = (X509Crl)obj;
        return Arrays.equals(this.encoded, other.encoded);
    }

    public byte[] getAuthorityKeyIdentifier() {
        return X509CertificateUtil.getAuthorityKeyIdentifier(this.getCrl());
    }

    public DateTime getThisUpdateTime() {
        return new DateTime((Object)this.getCrl().getThisUpdate(), DateTimeZone.UTC);
    }

    public DateTime getNextUpdateTime() {
        return new DateTime((Object)this.getCrl().getNextUpdate(), DateTimeZone.UTC);
    }

    public X500Principal getIssuer() {
        return this.getCrl().getIssuerX500Principal();
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, CrlLocator crlLocator, ValidationOptions options, ValidationResult result) {
        X509CrlValidator crlValidator = new X509CrlValidator(options, result, context.getCertificate());
        crlValidator.validate(location, this);
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, X509Crl crl, URI crlUri, ValidationOptions options, ValidationResult result) {
        this.validate(location, context, null, options, result);
    }

    @Override
    public boolean isPastValidityTime() {
        return this.getNextUpdateTime().isBeforeNow();
    }

    @Override
    public boolean isRevoked() {
        return false;
    }

    public int getVersion() {
        return this.getCrl().getVersion();
    }

    public String getSigAlgName() {
        return this.getCrl().getSigAlgName();
    }

    public SortedSet<Entry> getRevokedCertificates() {
        TreeSet<Entry> result = new TreeSet<Entry>();
        Set<? extends X509CRLEntry> entries = this.getCrl().getRevokedCertificates();
        if (entries != null) {
            for (X509CRLEntry x509CRLEntry : entries) {
                result.add(new Entry(x509CRLEntry));
            }
        }
        return result;
    }

    public Entry getRevokedCertificate(BigInteger serialNumber) {
        X509CRLEntry entry = this.getCrl().getRevokedCertificate(serialNumber);
        return entry == null ? null : new Entry(entry);
    }

    public BigInteger getNumber() {
        try {
            byte[] extensionValue = this.getCrl().getExtensionValue(Extension.cRLNumber.getId());
            if (extensionValue == null) {
                return null;
            }
            ASN1Integer number = (ASN1Integer)X509ExtensionUtil.fromExtensionValue((byte[])extensionValue);
            return number.getPositiveValue();
        }
        catch (IOException e) {
            throw new X509CrlException("cannot get CRLNumber extension from CRL", e);
        }
    }

    @Override
    public URI getCrlUri() {
        return null;
    }

    @Override
    public URI getParentCertificateUri() {
        throw new UnsupportedOperationException();
    }

    public void verify(PublicKey publicKey) throws SignatureException {
        try {
            this.getCrl().verify(publicKey, "SunRsaSign");
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
        catch (CRLException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isRevoked(X509Certificate certificate) {
        return this.getCrl().isRevoked(certificate);
    }

    public static class Entry
    extends EqualsSupport
    implements Comparable<Entry>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final BigInteger serialNumber;
        private final DateTime revocationDateTime;

        public Entry(BigInteger serial, DateTime revocationDateTime) {
            Validate.notNull((Object)serial, (String)"serial is required");
            Validate.notNull((Object)revocationDateTime, (String)"revocationDateTime is required");
            this.serialNumber = serial;
            this.revocationDateTime = revocationDateTime.withMillisOfSecond(0);
        }

        public Entry(X509CRLEntry entry) {
            this.serialNumber = entry.getSerialNumber();
            this.revocationDateTime = new DateTime((Object)entry.getRevocationDate(), DateTimeZone.UTC);
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        public DateTime getRevocationDateTime() {
            return this.revocationDateTime;
        }

        @Override
        public int compareTo(Entry o) {
            return this.getSerialNumber().compareTo(o.getSerialNumber());
        }
    }

    public static class X509CRLEntryComparator
    implements Comparator<X509CRLEntry> {
        @Override
        public int compare(X509CRLEntry o1, X509CRLEntry o2) {
            return o1.getSerialNumber().compareTo(o2.getSerialNumber());
        }
    }
}

