/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStoreException;
import java.security.cert.X509Extension;
import java.util.Collection;
import net.ripe.rpki.commons.crypto.cms.RPKISignedData;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObject;
import net.ripe.rpki.commons.crypto.util.BouncyCastleUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectBuilder;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import net.ripe.rpki.commons.provisioning.payload.list.request.ResourceClassListQueryPayload;
import net.ripe.rpki.commons.provisioning.payload.list.request.ResourceClassListQueryPayloadBuilder;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificateBuilderTest;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.util.Selector;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProvisioningCmsObjectBuilderTest {
    private ProvisioningCmsObject cmsObject;
    private long signingTime;
    private ProvisioningCmsObjectBuilder subject;
    private CMSSignedDataParser signedDataParser;

    @Before
    public void setUp() throws Exception {
        ResourceClassListQueryPayloadBuilder payloadBuilder = new ResourceClassListQueryPayloadBuilder();
        ResourceClassListQueryPayload payload = payloadBuilder.build();
        this.subject = new ProvisioningCmsObjectBuilder();
        this.subject.withCmsCertificate(ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getCertificate());
        this.subject.withCrl(ProvisioningObjectMother.CRL);
        this.subject.withSignatureProvider("SunRsaSign");
        this.subject.withPayloadContent((AbstractProvisioningPayload)payload);
        this.signingTime = new DateTime().getMillis() / 1000L * 1000L;
        DateTimeUtils.setCurrentMillisFixed((long)this.signingTime);
        this.cmsObject = this.subject.build(ProvisioningCmsCertificateBuilderTest.EE_KEYPAIR.getPrivate());
        DateTimeUtils.setCurrentMillisSystem();
        this.signedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), this.cmsObject.getEncoded());
        this.signedDataParser.getSignedContent().drain();
    }

    public static ProvisioningCmsObject createProvisioningCmsObjectForPayload(AbstractProvisioningPayload payload) {
        ProvisioningCmsObjectBuilder builder = new ProvisioningCmsObjectBuilder();
        builder.withCmsCertificate(ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getCertificate());
        builder.withCrl(ProvisioningObjectMother.CRL);
        builder.withSignatureProvider("SunRsaSign");
        builder.withPayloadContent(payload);
        return builder.build(ProvisioningCmsCertificateBuilderTest.EE_KEYPAIR.getPrivate());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldForceCertificate() throws CMSException {
        this.subject.withCmsCertificate(null);
        this.subject.build(ProvisioningCmsCertificateBuilderTest.EE_KEYPAIR.getPrivate());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldForceCrl() throws CMSException {
        this.subject.withCrl(null);
        this.subject.build(ProvisioningCmsCertificateBuilderTest.EE_KEYPAIR.getPrivate());
    }

    @Test
    public void shouldNotForceIdentityCertificate() throws CMSException {
        this.subject.build(ProvisioningCmsCertificateBuilderTest.EE_KEYPAIR.getPrivate());
    }

    @Test
    public void shouldCmsObjectHaveCorrectVersionNumber() throws Exception {
        Assert.assertEquals((long)3L, (long)this.signedDataParser.getVersion());
    }

    @Test
    public void shouldCmsObjectHaveCorrectDigestAlgorithm() throws Exception {
        ASN1InputStream in = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.cmsObject.getEncoded()));
        ContentInfo info = ContentInfo.getInstance((Object)in.readObject());
        RPKISignedData signedData = RPKISignedData.getInstance((Object)info.getContent());
        ASN1Set digestAlgorithms = signedData.getDigestAlgorithms();
        ASN1Encodable asn1Object = digestAlgorithms.getObjectAt(0);
        AlgorithmIdentifier algorithmId = AlgorithmIdentifier.getInstance((Object)asn1Object.toASN1Primitive());
        Assert.assertEquals((Object)CMSSignedGenerator.DIGEST_SHA256, (Object)algorithmId.getAlgorithm().getId());
    }

    @Test
    public void shouldCmsObjectHaveCorrectContentType() throws Exception {
        Assert.assertEquals((Object)new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.28"), (Object)this.signedDataParser.getSignedContent().getContentType());
    }

    @Test
    public void shouldCmsObjectHaveEmbeddedSigningCertificate() throws Exception {
        Collection<? extends X509CertificateHolder> certificates = this.getCertificates();
        Assert.assertNotNull(certificates);
        Assert.assertEquals((String)"size", (long)1L, (long)certificates.size());
        X509CertificateHolder holder = certificates.iterator().next();
        Assert.assertEquals((Object)new JcaX509CertificateHolder(ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getCertificate()), (Object)holder);
    }

    private Collection<? extends X509CertificateHolder> getCertificates() throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, CertStoreException {
        return this.signedDataParser.getCertificates().getMatches((Selector)new BouncyCastleUtil.X509CertificateHolderStoreSelector());
    }

    @Test
    public void shouldCmsObjectHaveEmbeddedCrl() throws Exception {
        Collection crls = this.signedDataParser.getCRLs().getMatches((Selector)new BouncyCastleUtil.X509CRLHolderStoreSelector());
        Assert.assertNotNull((Object)crls);
        Assert.assertFalse((boolean)crls.isEmpty());
        Assert.assertEquals((Object)new JcaX509CRLHolder(ProvisioningObjectMother.CRL), crls.iterator().next());
    }

    @Test
    public void shouldCmsObjectHaveOnlyOneSigner() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        Assert.assertNotNull((Object)signers);
        Assert.assertEquals((long)1L, (long)signers.size());
    }

    @Test
    public void shouldCmsObjectSignerVersionBeCorrect() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        Assert.assertEquals((long)3L, (long)signer.getVersion());
    }

    @Test
    public void shouldCmsObjectHaveCorrectSubjectKeyIdentifier() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        Assert.assertArrayEquals((byte[])X509CertificateUtil.getSubjectKeyIdentifier((X509Extension)ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getCertificate()), (byte[])signer.getSID().getSubjectKeyIdentifier());
    }

    @Test
    public void shouldCmsObjectHaveSubjectKeyIdentifierOnly() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        Assert.assertNull((Object)signer.getSID().getIssuer());
        Assert.assertNull((Object)signer.getSID().getSerialNumber());
    }

    @Test
    public void shouldCmsObjectHaveCorrectDigestAlgorithmOID() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        Assert.assertEquals((Object)CMSSignedGenerator.DIGEST_SHA256, (Object)signer.getDigestAlgOID());
    }

    @Test
    public void shouldCmsObjectHaveSignedAttributes() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        Assert.assertNotNull((Object)signer.getSignedAttributes());
    }

    @Test
    public void shouldCmsObjectHaveCorrectContentTypeSignedAttribute() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        AttributeTable attributeTable = signer.getSignedAttributes();
        Attribute contentType = attributeTable.get(CMSAttributes.contentType);
        Assert.assertNotNull((Object)contentType);
        Assert.assertEquals((long)1L, (long)contentType.getAttrValues().size());
        Assert.assertEquals((Object)new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.28"), (Object)contentType.getAttrValues().getObjectAt(0));
    }

    @Test
    public void shouldCmsObjectHaveCorrectMessageDigestSignedAttribute() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        AttributeTable attributeTable = signer.getSignedAttributes();
        Attribute messageDigest = attributeTable.get(CMSAttributes.messageDigest);
        Assert.assertNotNull((Object)messageDigest);
        Assert.assertEquals((long)1L, (long)messageDigest.getAttrValues().size());
        Assert.assertNotNull((Object)messageDigest.getAttrValues().getObjectAt(0));
    }

    @Test
    public void shouldCmsObjectHaveSigningTimeSignedAttribute() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        AttributeTable attributeTable = signer.getSignedAttributes();
        Attribute signingTimeAttr = attributeTable.get(CMSAttributes.signingTime);
        Assert.assertNotNull((Object)signingTimeAttr);
        Assert.assertEquals((long)1L, (long)signingTimeAttr.getAttrValues().size());
        ASN1UTCTime signingTime = (ASN1UTCTime)signingTimeAttr.getAttrValues().getObjectAt(0);
        Assert.assertEquals((long)this.signingTime, (long)signingTime.getDate().getTime());
    }

    @Test
    public void shouldCmsObjectHaveNoBinarySigningTimeSignedAttribute() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        AttributeTable attributeTable = signer.getSignedAttributes();
        Attribute contentType = attributeTable.get(new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.46"));
        Assert.assertNull((Object)contentType);
    }

    @Test
    public void shouldCmsObjectHaveRSASignatureAlgorithm() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        Assert.assertEquals((Object)RpkiSignedObject.SHA256WITHRSA_ENCRYPTION_OID, (Object)signer.getEncryptionAlgOID());
    }

    @Test
    public void shouldCmsObjectHaveValidSignature() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        Assert.assertNotNull((Object)signer.getSignature());
        Assert.assertTrue((String)"signature verify", (boolean)signer.verify(new JcaSignerInfoVerifierBuilder(BouncyCastleUtil.DIGEST_CALCULATOR_PROVIDER).build(ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getCertificate())));
    }

    @Test
    public void shouldCmsObjectHaveNoUnsignedAttribute() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        Assert.assertNull((Object)signer.getUnsignedAttributes());
    }

    @Test
    public void shouldCmsObjectHaveNoRedundantAttribute() throws Exception {
        Collection signers = this.signedDataParser.getSignerInfos().getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        AttributeTable attributeTable = signer.getSignedAttributes();
        Assert.assertNull((Object)attributeTable.get(CMSAttributes.cmsAlgorithmProtect));
    }
}

