/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateBuilderHelper;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificateParser;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class X509RouterCertificateParserTest {
    private X509RouterCertificateParser subject = new X509RouterCertificateParser();

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireResourceCertificatePolicy() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withPolicies(new PolicyInformation[0]);
        X509ResourceCertificate certificate = builder.build();
        this.subject.parse("certificate", certificate.getEncoded());
        this.subject.getCertificate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotParseResourceCertificateWhenResourceExtensionsArePresent() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        X509ResourceCertificate certificate = builder.build();
        this.subject.parse("certificate", certificate.getEncoded());
        this.subject.getCertificate();
    }

    @Test
    public void shouldFailOnInvalidInput() {
        byte[] badlyEncoded = new byte[]{1, 3, 35};
        this.subject.parse("badly", badlyEncoded);
        Assert.assertTrue((boolean)this.subject.getValidationResult().getFailures(new ValidationLocation("badly")).contains(new ValidationCheck(ValidationStatus.ERROR, "cert.parsed", new String[0])));
    }

    @Test
    public void shouldFailOnInvalidSignatureAlgorithm() throws CertificateEncodingException {
        X509CertificateBuilderHelper builder = new X509CertificateBuilderHelper();
        builder.withSubjectDN(new X500Principal("CN=zz.subject")).withIssuerDN(new X500Principal("CN=zz.issuer"));
        builder.withSerial(BigInteger.ONE);
        builder.withPublicKey(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR);
        DateTime now = new DateTime(DateTimeZone.UTC);
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)now, (ReadableInstant)new DateTime(now.getYear() + 1, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC)));
        builder.withResources(IpResourceSet.ALL_PRIVATE_USE_RESOURCES);
        builder.withSignatureAlgorithm("MD5withRSA");
        X509Certificate certificate = builder.generateCertificate();
        this.subject.parse("certificate", certificate.getEncoded());
        Assert.assertTrue((boolean)this.subject.getValidationResult().hasFailures());
        Assert.assertFalse((boolean)this.subject.getValidationResult().getResult(new ValidationLocation("certificate"), "cert.signature.algorithm").isOk());
    }

    @Test
    public void should_validate_key_algorithm_and_size() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        X509ResourceCertificate certificate = builder.build();
        this.subject.parse("certificate", certificate.getEncoded());
        Assert.assertTrue((boolean)this.subject.getValidationResult().getResult(new ValidationLocation("certificate"), "cert.public.key.algorithm").isOk());
        Assert.assertTrue((boolean)this.subject.getValidationResult().getResult(new ValidationLocation("certificate"), "cert.public.key.size").isOk());
    }

    @Test
    public void should_parse_the_real_router_certificate() throws IOException {
        byte[] encoded = Files.toByteArray((File)new File("src/test/resources/router/router_certificate.cer"));
        this.subject.parse("certificate", encoded);
        ValidationResult validationResult = this.subject.getValidationResult();
        Assert.assertFalse((boolean)validationResult.hasFailureForCurrentLocation());
        X509RouterCertificate certificate = this.subject.getCertificate();
        Assert.assertNotNull((Object)certificate);
    }
}

