/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificateBuilder;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class X509RouterCertificateTest {
    private static final URI MFT_URI = URI.create("rsync://host.foo/bar/ta.mft");
    private static final URI PUB_DIR_URI = URI.create("rsync://host.foo/bar/");
    public static final X500Principal TEST_SELF_SIGNED_CERTIFICATE_NAME = new X500Principal("CN=TEST-SELF-SIGNED-CERT");
    private static final ValidityPeriod TEST_VALIDITY_PERIOD = new ValidityPeriod((ReadableInstant)new DateTime().minusMinutes(1), (ReadableInstant)new DateTime().plusYears(100));
    private static final BigInteger TEST_SERIAL_NUMBER = BigInteger.valueOf(900L);

    public static X509RouterCertificateBuilder createBasicBuilder() {
        X509RouterCertificateBuilder builder = new X509RouterCertificateBuilder();
        builder.withSubjectDN(TEST_SELF_SIGNED_CERTIFICATE_NAME);
        builder.withIssuerDN(TEST_SELF_SIGNED_CERTIFICATE_NAME);
        builder.withSerial(TEST_SERIAL_NUMBER);
        builder.withValidityPeriod(TEST_VALIDITY_PERIOD);
        builder.withPublicKey(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(KeyPairFactoryTest.TEST_KEY_PAIR);
        builder.withAuthorityKeyIdentifier(true);
        builder.withAsns(new int[]{1, 22, 333});
        return builder;
    }

    public static X509RouterCertificateBuilder createSelfSignedRouterCertificateBuilder() {
        return X509RouterCertificateTest.createBasicBuilder().withCa(false).withSubjectDN(TEST_SELF_SIGNED_CERTIFICATE_NAME).withIssuerDN(TEST_SELF_SIGNED_CERTIFICATE_NAME);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireCertificate() {
        new X509RouterCertificate(null);
    }

    @Test
    public void shouldSupportCaCertificate() {
        X509RouterCertificate cert = X509RouterCertificateTest.createSelfSignedRouterCertificateBuilder().build();
        Assert.assertFalse((boolean)cert.isCa());
        Assert.assertTrue((boolean)cert.isRouter());
    }

    @Test
    public void shouldSupportAuthorityInformationAccessExtension() throws URISyntaxException {
        Object[] descriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS, new URI("rsync://foo.host/bar/baz.cer")), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS, new URI("http://foo.host/bar/baz.cer"))};
        X509RouterCertificateBuilder builder = X509RouterCertificateTest.createSelfSignedRouterCertificateBuilder();
        builder.withAuthorityInformationAccess((X509CertificateInformationAccessDescriptor[])descriptors);
        X509RouterCertificate cert = builder.build();
        Assert.assertArrayEquals((Object[])descriptors, (Object[])cert.getAuthorityInformationAccess());
        Assert.assertEquals((Object)descriptors[0].getLocation(), (Object)cert.findFirstAuthorityInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS));
        Assert.assertNull((Object)cert.findFirstAuthorityInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST));
        Assert.assertNotNull((Object)cert.findFirstAuthorityInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS));
    }

    @Test
    public void shouldSupportSubjectInformationAccessExtension() throws URISyntaxException {
        Object[] descriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, new URI("rsync://foo.host/bar/")), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, new URI("http://foo.host/bar/"))};
        X509RouterCertificateBuilder builder = X509RouterCertificateTest.createSelfSignedRouterCertificateBuilder();
        builder.withSubjectInformationAccess((X509CertificateInformationAccessDescriptor[])descriptors);
        X509RouterCertificate cert = builder.build();
        Assert.assertArrayEquals((Object[])descriptors, (Object[])cert.getSubjectInformationAccess());
        Assert.assertNotNull((Object)cert.findFirstSubjectInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY));
    }

    @Test
    public void shouldSupportCrlDistributionPoints() {
        Object[] crlDistributionPoints = new URI[]{URI.create("rsync://localhost/ca.crl")};
        X509RouterCertificateBuilder builder = X509RouterCertificateTest.createSelfSignedRouterCertificateBuilder();
        builder.withCrlDistributionPoints((URI[])crlDistributionPoints);
        X509RouterCertificate cert = builder.build();
        Assert.assertArrayEquals((Object[])crlDistributionPoints, (Object[])cert.getCrlDistributionPoints());
        Assert.assertNotNull((Object)cert.findFirstRsyncCrlDistributionPoint());
    }

    @Test
    public void shouldHaveValidSignature() throws InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        X509RouterCertificate certificate = X509RouterCertificateTest.createSelfSignedRouterCertificateBuilder().build();
        certificate.getCertificate().verify(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
    }

    @Test(expected=SignatureException.class)
    public void shouldFailOnInvalidSignature() throws InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        X509RouterCertificate certificate = X509RouterCertificateTest.createSelfSignedRouterCertificateBuilder().build();
        certificate.getCertificate().verify(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR.getPublic());
    }
}

