/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.roa;

import java.util.LinkedList;
import java.util.List;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.etree.IntervalStrategy;
import net.ripe.ipresource.etree.IpResourceIntervalStrategy;
import net.ripe.ipresource.etree.NestedIntervalMap;
import net.ripe.rpki.commons.validation.roa.RoaPrefixData;
import net.ripe.rpki.commons.validation.roa.RouteData;
import net.ripe.rpki.commons.validation.roa.RouteValidityState;

public final class RouteOriginValidationPolicy {
    public static <T extends RoaPrefixData> NestedIntervalMap<IpResource, List<T>> allowedRoutesToNestedIntervalMap(Iterable<T> allowedRoutes) {
        NestedIntervalMap result = new NestedIntervalMap((IntervalStrategy)IpResourceIntervalStrategy.getInstance());
        for (RoaPrefixData allowedRoute : allowedRoutes) {
            LinkedList<RoaPrefixData> allowed = (LinkedList<RoaPrefixData>)result.findExact((Object)allowedRoute.getPrefix());
            if (allowed == null) {
                allowed = new LinkedList<RoaPrefixData>();
                result.put((Object)allowedRoute.getPrefix(), allowed);
            }
            allowed.add(allowedRoute);
        }
        return result;
    }

    public static <T extends RoaPrefixData, U extends RouteData> RouteValidityState validateAnnouncedRoute(NestedIntervalMap<IpResource, ? extends Iterable<T>> allowedRoutes, U announcedRoute) {
        RouteValidityState result = RouteValidityState.UNKNOWN;
        for (Iterable routes : allowedRoutes.findExactAndAllLessSpecific((Object)announcedRoute.getPrefix())) {
            for (RoaPrefixData allowedRoute : routes) {
                switch (RouteOriginValidationPolicy.validate(allowedRoute, announcedRoute)) {
                    case VALID: {
                        return RouteValidityState.VALID;
                    }
                    case INVALID_ASN: {
                        result = RouteValidityState.INVALID_ASN;
                        break;
                    }
                    case INVALID_LENGTH: {
                        result = RouteValidityState.INVALID_LENGTH;
                        break;
                    }
                }
            }
        }
        return result;
    }

    private static <T extends RoaPrefixData, U extends RouteData> RouteValidityState validate(T allowedRoute, U announcedRoute) {
        IpRange announcedPrefix = announcedRoute.getPrefix();
        if (RouteOriginValidationPolicy.isUnknown(allowedRoute, announcedPrefix)) {
            return RouteValidityState.UNKNOWN;
        }
        if (RouteOriginValidationPolicy.isAsnInvalid(allowedRoute, announcedRoute)) {
            return RouteValidityState.INVALID_ASN;
        }
        if (RouteOriginValidationPolicy.isLengthInvalid(allowedRoute, announcedPrefix)) {
            return RouteValidityState.INVALID_LENGTH;
        }
        return RouteValidityState.VALID;
    }

    private static <T extends RoaPrefixData> boolean isUnknown(T allowedRoute, IpRange announcedPrefix) {
        return !allowedRoute.getPrefix().contains((IpResource)announcedPrefix);
    }

    private static <T extends RoaPrefixData> boolean isLengthInvalid(T allowedRoute, IpRange announcedPrefix) {
        return announcedPrefix.getPrefixLength() > allowedRoute.getMaximumLength();
    }

    private static <T extends RoaPrefixData, U extends RouteData> boolean isAsnInvalid(T allowedRoute, U announcedRoute) {
        return !allowedRoute.getAsn().equals((Object)announcedRoute.getOriginAsn());
    }

    private RouteOriginValidationPolicy() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

