/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.roa;

import java.util.Comparator;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.validation.roa.AllowedRoute;

public interface RoaPrefixData
extends Comparable<RoaPrefixData> {
    public static final Comparator<RoaPrefixData> ROA_PREFIX_DATA_COMPARATOR = Comparator.comparing(RoaPrefixData::getAsn).thenComparing(RoaPrefixData::getPrefix).thenComparing(RoaPrefixData::getMaximumLength);

    public Asn getAsn();

    public IpRange getPrefix();

    public int getMaximumLength();

    @Override
    default public int compareTo(RoaPrefixData o) {
        return ROA_PREFIX_DATA_COMPARATOR.compare(this, o);
    }

    default public AllowedRoute toAllowedRoute() {
        return new AllowedRoute(this.getAsn(), this.getPrefix(), this.getMaximumLength());
    }
}

