/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.roa;

import java.io.Serializable;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.validation.roa.RouteData;
import org.apache.commons.lang3.Validate;

public final class AnnouncedRoute
implements Serializable,
RouteData {
    private static final long serialVersionUID = 1L;
    private final Asn originAsn;
    private final IpRange prefix;

    public AnnouncedRoute(Asn originAsn, IpRange prefix) {
        Validate.notNull((Object)originAsn, (String)"origin is required", (Object[])new Object[0]);
        Validate.isTrue((boolean)prefix.isLegalPrefix(), (String)"Prefix must be legal", (Object[])new Object[0]);
        this.originAsn = originAsn;
        this.prefix = prefix;
    }

    public String toString() {
        return "AnnouncedRoute [originAsn=" + this.originAsn + ", prefix=" + this.prefix + "]";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnouncedRoute)) {
            return false;
        }
        AnnouncedRoute other = (AnnouncedRoute)o;
        Asn this$originAsn = this.getOriginAsn();
        Asn other$originAsn = other.getOriginAsn();
        if (this$originAsn == null ? other$originAsn != null : !this$originAsn.equals(other$originAsn)) {
            return false;
        }
        IpRange this$prefix = this.getPrefix();
        IpRange other$prefix = other.getPrefix();
        return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Asn $originAsn = this.getOriginAsn();
        result = result * 59 + ($originAsn == null ? 43 : $originAsn.hashCode());
        IpRange $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        return result;
    }

    @Override
    public Asn getOriginAsn() {
        return this.originAsn;
    }

    @Override
    public IpRange getPrefix() {
        return this.prefix;
    }
}

