/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.roa;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.cms.roa.Roa;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.validation.roa.AnnouncedRoute;
import net.ripe.rpki.commons.validation.roa.RoaPrefixData;
import org.apache.commons.lang3.Validate;

public class AllowedRoute
implements RoaPrefixData,
Serializable {
    private static final long serialVersionUID = 2L;
    private final Asn asn;
    private final IpRange prefix;
    private final int maximumLength;

    public AllowedRoute(Asn asn, IpRange prefix, int maximumLength) {
        Validate.notNull((Object)asn, (String)"asn is required", (Object[])new Object[0]);
        Validate.notNull((Object)prefix, (String)"prefix is required", (Object[])new Object[0]);
        Validate.isTrue((maximumLength >= 0 && maximumLength <= prefix.getType().getBitSize() ? 1 : 0) != 0, (String)"maximumLength out of bounds", (Object[])new Object[0]);
        this.asn = asn;
        this.prefix = prefix;
        this.maximumLength = maximumLength;
    }

    public static List<AllowedRoute> fromRoas(List<? extends Roa> roas) {
        return roas.stream().flatMap(roa -> roa.getPrefixes().stream().map(roaPrefix -> new AllowedRoute(roa.getAsn(), roaPrefix.getPrefix(), roaPrefix.getEffectiveMaximumLength()))).collect(Collectors.toList());
    }

    @Override
    public Asn getAsn() {
        return this.asn;
    }

    @Override
    public IpRange getPrefix() {
        return this.prefix;
    }

    @Override
    public int getMaximumLength() {
        return this.maximumLength;
    }

    public AnnouncedRoute getAnnouncedRoute() {
        return new AnnouncedRoute(this.asn, this.prefix);
    }

    public RoaPrefix getRoaPrefix() {
        Integer maxLen = this.prefix.getPrefixLength() == this.maximumLength ? null : Integer.valueOf(this.maximumLength);
        return new RoaPrefix(this.prefix, maxLen);
    }

    public String toString() {
        return "AllowedRoute(asn=" + this.getAsn() + ", prefix=" + this.getPrefix() + ", maximumLength=" + this.getMaximumLength() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllowedRoute)) {
            return false;
        }
        AllowedRoute other = (AllowedRoute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaximumLength() != other.getMaximumLength()) {
            return false;
        }
        Asn this$asn = this.getAsn();
        Asn other$asn = other.getAsn();
        if (this$asn == null ? other$asn != null : !this$asn.equals(other$asn)) {
            return false;
        }
        IpRange this$prefix = this.getPrefix();
        IpRange other$prefix = other.getPrefix();
        return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AllowedRoute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaximumLength();
        Asn $asn = this.getAsn();
        result = result * 59 + ($asn == null ? 43 : $asn.hashCode());
        IpRange $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        return result;
    }
}

