/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.util;

import java.util.Arrays;

public enum RepositoryObjectType {
    Certificate("cer", false),
    Crl("crl", false),
    Aspa("asa", true),
    Gbr("gbr", true),
    Manifest("mft", true),
    Roa("roa", true),
    SignedChecklist("sig", true),
    TrustAnchorKey("tak", true),
    Unknown("unknown", false);

    private final boolean isCmsBased;
    private final String fileExtension;

    private RepositoryObjectType(String fileExtension, boolean isCmsBased) {
        this.fileExtension = fileExtension;
        this.isCmsBased = isCmsBased;
    }

    public static RepositoryObjectType parse(String name) {
        return Arrays.stream(RepositoryObjectType.values()).filter(t -> name.endsWith("." + t.getFileExtension())).findFirst().orElse(Unknown);
    }

    public boolean isCmsBased() {
        return this.isCmsBased;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }
}

