/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.x509;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.security.KeyPair;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateBuilderHelper;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.util.UTC;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ProvisioningIdentityCertificateBuilder {
    private static final int DEFAULT_VALIDITY_TIME_YEARS_FROM_NOW = 10;
    private X509CertificateBuilderHelper builderHelper = new X509CertificateBuilderHelper();
    private KeyPair selfSigningKeyPair;
    private X500Principal selfSigningSubject;
    private String signatureProvider = "SunRsaSign";

    public ProvisioningIdentityCertificateBuilder withSelfSigningKeyPair(KeyPair selfSigningKeyPair) {
        this.selfSigningKeyPair = selfSigningKeyPair;
        return this;
    }

    public ProvisioningIdentityCertificateBuilder withSelfSigningSubject(X500Principal selfSigningSubject) {
        this.selfSigningSubject = selfSigningSubject;
        return this;
    }

    public ProvisioningIdentityCertificateBuilder withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public ProvisioningIdentityCertificate build() {
        Preconditions.checkNotNull((Object)this.selfSigningKeyPair, (Object)"Self Signing KeyPair is required");
        Preconditions.checkNotNull((Object)this.selfSigningSubject, (Object)"Self Signing DN is required");
        Preconditions.checkNotNull((Object)this.signatureProvider, (Object)"Signature Provider is required");
        this.setUpImplicitRequirementsForBuilderHelper();
        this.builderHelper.withPublicKey(this.selfSigningKeyPair.getPublic());
        this.builderHelper.withSigningKeyPair(this.selfSigningKeyPair);
        this.builderHelper.withSubjectDN(this.selfSigningSubject);
        this.builderHelper.withIssuerDN(this.selfSigningSubject);
        this.builderHelper.withSignatureProvider(this.signatureProvider);
        return new ProvisioningIdentityCertificate(this.builderHelper.generateCertificate());
    }

    private void setUpImplicitRequirementsForBuilderHelper() {
        this.builderHelper.withSerial(BigInteger.ONE);
        DateTime now = UTC.dateTime();
        this.builderHelper.withValidityPeriod(new ValidityPeriod((ReadableInstant)now, (ReadableInstant)now.plusYears(10)));
        this.builderHelper.withCa(true);
        this.builderHelper.withKeyUsage(6);
    }
}

