/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.crl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilderException;
import net.ripe.rpki.commons.crypto.util.BouncyCastleUtil;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.joda.time.DateTime;

public class X509CrlBuilder {
    public static final int CRL_VERSION_2 = 2;
    private X500Principal issuerDN;
    private DateTime thisUpdateTime;
    private DateTime nextUpdateTime;
    private AuthorityKeyIdentifier authorityKeyIdentifier;
    private CRLNumber crlNumber;
    private String signatureProvider = "SunRsaSign";
    private SortedMap<BigInteger, X509Crl.Entry> entries = new TreeMap<BigInteger, X509Crl.Entry>();

    public X509CrlBuilder withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public X509CrlBuilder withIssuerDN(X500Principal issuerDN) {
        this.issuerDN = issuerDN;
        return this;
    }

    @Deprecated
    public X509CrlBuilder withThisUpdateTime(DateTime instant) {
        this.thisUpdateTime = instant;
        return this;
    }

    @Deprecated
    public X509CrlBuilder withNextUpdateTime(DateTime instant) {
        this.nextUpdateTime = instant;
        return this;
    }

    public X509CrlBuilder withValidityPeriod(ValidityPeriod validityPeriod) {
        this.thisUpdateTime = validityPeriod.getNotValidBefore();
        this.nextUpdateTime = validityPeriod.getNotValidAfter();
        return this;
    }

    public X509CrlBuilder withNumber(BigInteger number) {
        if (number.signum() <= 0 || number.abs().bitLength() > 160) {
            throw new IllegalArgumentException(number + " CRL number must be positive and be representable by 20 octets or less.");
        }
        this.crlNumber = new CRLNumber(number);
        return this;
    }

    public X509CrlBuilder withAuthorityKeyIdentifier(PublicKey authorityKey) {
        this.authorityKeyIdentifier = BouncyCastleUtil.createAuthorityKeyIdentifier(authorityKey);
        return this;
    }

    public X509CrlBuilder addEntry(BigInteger serial, DateTime revocationTime) {
        Validate.isTrue((!this.entries.containsKey(serial) ? 1 : 0) != 0, (String)"duplicate CRL entry", (Object[])new Object[0]);
        this.entries.put(serial, new X509Crl.Entry(serial, revocationTime));
        return this;
    }

    public X509Crl.Entry getRevokedCertificate(BigInteger serial) {
        return (X509Crl.Entry)this.entries.get(serial);
    }

    public X509CrlBuilder clearEntries() {
        this.entries.clear();
        return this;
    }

    public X509Crl build(PrivateKey key) {
        this.validateCrlFields();
        try {
            X509v2CRLBuilder generator = this.createCrlGenerator();
            ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider(this.signatureProvider).build(key);
            return new X509Crl(generator.build(signer).getEncoded());
        }
        catch (OperatorCreationException e) {
            throw new X509CrlBuilderException(e);
        }
        catch (IOException e) {
            throw new X509CrlBuilderException(e);
        }
    }

    private void validateCrlFields() {
        Validate.notNull((Object)this.issuerDN, (String)"issuerDN is null", (Object[])new Object[0]);
        Validate.notNull((Object)this.thisUpdateTime, (String)"thisUpdateTime is null", (Object[])new Object[0]);
        Validate.notNull((Object)this.nextUpdateTime, (String)"nextUpdateTime is null", (Object[])new Object[0]);
        Validate.notNull((Object)this.crlNumber, (String)"crlNumber is null", (Object[])new Object[0]);
        Validate.notNull((Object)this.authorityKeyIdentifier, (String)"authorityKeyIdentifier is null", (Object[])new Object[0]);
    }

    private X509v2CRLBuilder createCrlGenerator() throws CertIOException {
        X509v2CRLBuilder generator = new X509v2CRLBuilder(X500Name.getInstance((Object)this.issuerDN.getEncoded()), this.thisUpdateTime.toDate());
        generator.setNextUpdate(this.nextUpdateTime.toDate());
        generator.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)this.authorityKeyIdentifier);
        generator.addExtension(Extension.cRLNumber, false, (ASN1Encodable)this.crlNumber);
        for (X509Crl.Entry entry : this.entries.values()) {
            generator.addCRLEntry(entry.getSerialNumber(), entry.getRevocationDateTime().toDate(), 0);
        }
        return generator;
    }

    public boolean isSatisfiedByEntries(X509Crl crl) {
        SortedSet<X509Crl.Entry> crlEntries = crl.getRevokedCertificates();
        return crlEntries.containsAll(this.entries.values());
    }

    public DateTime getThisUpdateTime() {
        return this.thisUpdateTime;
    }

    public DateTime getNextUpdateTime() {
        return this.nextUpdateTime;
    }
}

