/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.crl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509CrlException;
import net.ripe.rpki.commons.crypto.crl.X509CrlValidator;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.joda.time.DateTime;

public class X509Crl
implements CertificateRepositoryObject {
    private static final long serialVersionUID = 1L;
    private final byte[] encoded;
    private transient X509CRL crl;

    public X509Crl(byte[] encoded) {
        Validate.notNull((Object)encoded);
        this.encoded = encoded;
    }

    public X509Crl(X509CRL crl) {
        Validate.notNull((Object)crl);
        try {
            this.crl = crl;
            this.encoded = crl.getEncoded();
        }
        catch (CRLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }

    public X509CRL getCrl() {
        if (this.crl == null) {
            this.crl = X509Crl.makeX509CRLFromEncoded(this.encoded);
        }
        return this.crl;
    }

    public static X509Crl parseDerEncoded(byte[] encoded, ValidationResult validationResult) {
        try {
            X509Crl crl = new X509Crl(X509Crl.makeX509CRLFromEncoded(encoded));
            validationResult.pass("crl.parsed");
            return crl;
        }
        catch (IllegalArgumentException e) {
            validationResult.error("crl.parsed");
            return null;
        }
    }

    private static X509CRL makeX509CRLFromEncoded(byte[] encoded) {
        X509CRL x509CRL;
        if (encoded == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(encoded);
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            x509CRL = (X509CRL)factory.generateCRL(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (CRLException | CertificateException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error managing CRL I/O stream", e);
            }
        }
        in.close();
        return x509CRL;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.encoded);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509Crl other = (X509Crl)obj;
        return Arrays.equals(this.encoded, other.encoded);
    }

    public byte[] getAuthorityKeyIdentifier() {
        return X509CertificateUtil.getAuthorityKeyIdentifier(this.getCrl());
    }

    public DateTime getThisUpdateTime() {
        return UTC.dateTime(this.getCrl().getThisUpdate());
    }

    public DateTime getNextUpdateTime() {
        return UTC.dateTime(this.getCrl().getNextUpdate());
    }

    public X500Principal getIssuer() {
        return this.getCrl().getIssuerX500Principal();
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, CrlLocator crlLocator, ValidationOptions options, ValidationResult result) {
        X509CrlValidator crlValidator = new X509CrlValidator(options, result, context.getCertificate());
        crlValidator.validate(location, this);
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, X509Crl crl, URI crlUri, ValidationOptions options, ValidationResult result) {
        this.validate(location, context, null, options, result);
    }

    @Override
    public boolean isPastValidityTime() {
        return this.getNextUpdateTime().isBeforeNow();
    }

    @Override
    public boolean isRevoked() {
        return false;
    }

    public int getVersion() {
        return this.getCrl().getVersion();
    }

    public String getSigAlgName() {
        return this.getCrl().getSigAlgName();
    }

    public SortedSet<Entry> getRevokedCertificates() {
        TreeSet<Entry> result = new TreeSet<Entry>();
        Set<? extends X509CRLEntry> entries = this.getCrl().getRevokedCertificates();
        if (entries != null) {
            for (X509CRLEntry x509CRLEntry : entries) {
                result.add(new Entry(x509CRLEntry));
            }
        }
        return result;
    }

    public Entry getRevokedCertificate(BigInteger serialNumber) {
        X509CRLEntry entry = this.getCrl().getRevokedCertificate(serialNumber);
        return entry == null ? null : new Entry(entry);
    }

    public BigInteger getNumber() {
        try {
            byte[] extensionValue = this.getCrl().getExtensionValue(Extension.cRLNumber.getId());
            if (extensionValue == null) {
                return null;
            }
            ASN1Integer number = (ASN1Integer)JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionValue);
            return number.getPositiveValue();
        }
        catch (IOException e) {
            throw new X509CrlException("cannot get CRLNumber extension from CRL", e);
        }
    }

    @Override
    public URI getCrlUri() {
        return null;
    }

    @Override
    public URI getParentCertificateUri() {
        throw new UnsupportedOperationException();
    }

    public void verify(PublicKey publicKey) throws SignatureException {
        try {
            this.getCrl().verify(publicKey, "SunRsaSign");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | CRLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isRevoked(X509Certificate certificate) {
        return this.getCrl().isRevoked(certificate);
    }

    public static final class Entry
    implements Comparable<Entry>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final BigInteger serialNumber;
        private final DateTime revocationDateTime;

        public Entry(BigInteger serial, DateTime revocationDateTime) {
            Validate.notNull((Object)serial, (String)"serial is required", (Object[])new Object[0]);
            Validate.notNull((Object)revocationDateTime, (String)"revocationDateTime is required", (Object[])new Object[0]);
            this.serialNumber = serial;
            this.revocationDateTime = revocationDateTime.withMillisOfSecond(0);
        }

        public Entry(X509CRLEntry entry) {
            this.serialNumber = entry.getSerialNumber();
            this.revocationDateTime = UTC.dateTime(entry.getRevocationDate());
        }

        @Override
        public int compareTo(Entry o) {
            return this.getSerialNumber().compareTo(o.getSerialNumber());
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        public DateTime getRevocationDateTime() {
            return this.revocationDateTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            BigInteger this$serialNumber = this.getSerialNumber();
            BigInteger other$serialNumber = other.getSerialNumber();
            if (this$serialNumber == null ? other$serialNumber != null : !((Object)this$serialNumber).equals(other$serialNumber)) {
                return false;
            }
            DateTime this$revocationDateTime = this.getRevocationDateTime();
            DateTime other$revocationDateTime = other.getRevocationDateTime();
            return !(this$revocationDateTime == null ? other$revocationDateTime != null : !this$revocationDateTime.equals(other$revocationDateTime));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $serialNumber = this.getSerialNumber();
            result = result * 59 + ($serialNumber == null ? 43 : ((Object)$serialNumber).hashCode());
            DateTime $revocationDateTime = this.getRevocationDateTime();
            result = result * 59 + ($revocationDateTime == null ? 43 : $revocationDateTime.hashCode());
            return result;
        }

        public String toString() {
            return "X509Crl.Entry(serialNumber=" + this.getSerialNumber() + ", revocationDateTime=" + this.getRevocationDateTime() + ")";
        }
    }

    public static class X509CRLEntryComparator
    implements Comparator<X509CRLEntry> {
        @Override
        public int compare(X509CRLEntry o1, X509CRLEntry o2) {
            return o1.getSerialNumber().compareTo(o2.getSerialNumber());
        }
    }
}

