/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.aspa;

import com.google.common.base.Joiner;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectParser;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCms;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLTaggedObject;

public class AspaCmsParser
extends RpkiSignedObjectParser {
    private int version;
    @CheckForNull
    private Asn customerAsn;
    private ImmutableSortedSet<Asn> providerASSet = ImmutableSortedSet.of();

    @Override
    public void parse(ValidationResult result, byte[] encoded) {
        super.parse(result, encoded);
        this.validateAspa();
    }

    public AspaCms getAspa() {
        if (!this.isSuccess()) {
            throw new IllegalArgumentException("ASPA record validation failed: " + this.getValidationResult().getFailuresForCurrentLocation());
        }
        RpkiSignedObjectInfo cmsObjectData = new RpkiSignedObjectInfo(this.getEncoded(), this.getResourceCertificate(), this.getContentType(), this.getSigningTime());
        return new AspaCms(cmsObjectData, this.version, this.customerAsn, (SortedSet<Asn>)this.providerASSet);
    }

    public boolean isSuccess() {
        return !this.getValidationResult().hasFailureForCurrentLocation();
    }

    private void validateAspa() {
        ValidationResult validationResult = this.getValidationResult();
        validationResult.rejectIfFalse(AspaCms.CONTENT_TYPE.equals((ASN1Primitive)this.getContentType()), "aspa.content.type", String.valueOf(this.getContentType()));
        X509ResourceCertificate resourceCertificate = this.getCertificate();
        if (this.customerAsn != null) {
            validationResult.rejectIfFalse(resourceCertificate != null && resourceCertificate.containsResources(new IpResourceSet(new IpResource[]{this.customerAsn})), "aspa.customer.asn.certified");
            validationResult.rejectIfTrue(this.providerASSet.contains((Object)this.customerAsn), "aspa.customer.asn.ne.provider.asn", String.valueOf(this.customerAsn), Joiner.on((String)", ").join(this.providerASSet));
        }
    }

    @Override
    public void decodeAsn1Content(ASN1Encodable content) {
        ValidationResult validationResult = this.getValidationResult();
        try {
            ASN1Sequence seq = Asn1Util.expect(content, ASN1Sequence.class);
            int itemCount = seq.size();
            if (itemCount < 2 || itemCount > 3) {
                validationResult.error("aspa.content.structure");
                return;
            }
            int index = 0;
            ASN1Encodable maybeVersion = seq.getObjectAt(index);
            if (maybeVersion instanceof DLTaggedObject) {
                this.decodeVersion(validationResult, (DLTaggedObject)maybeVersion);
                ++index;
            } else {
                validationResult.rejectIfFalse(false, "aspa.version", "0 [missing]");
            }
            validationResult.rejectIfFalse(index < itemCount && seq.getObjectAt(index) instanceof ASN1Integer, "aspa.customer.asn.present");
            if (validationResult.hasFailureForCurrentLocation()) {
                return;
            }
            this.customerAsn = Asn1Util.parseAsId(seq.getObjectAt(index));
            if (++index >= itemCount) {
                validationResult.error("aspa.content.structure");
                return;
            }
            ASN1Sequence providerAsnsSequence = Asn1Util.expect(seq.getObjectAt(index), ASN1Sequence.class);
            List providerAsList = StreamSupport.stream(providerAsnsSequence.spliterator(), false).map(this::parseProviderAsn).collect(Collectors.toList());
            validationResult.rejectIfFalse(Comparators.isInStrictOrder(providerAsList, Comparator.naturalOrder()), "aspa.provider.as.set.valid", "elements are in order");
            if (validationResult.hasFailureForCurrentLocation()) {
                return;
            }
            this.providerASSet = ImmutableSortedSet.copyOf(providerAsList);
            validationResult.rejectIfFalse(this.providerASSet.size() == providerAsnsSequence.size(), "aspa.provider.as.set.valid", "elements are unique");
            validationResult.rejectIfTrue(this.providerASSet.isEmpty(), "aspa.provider.as.set.not.empty");
        }
        catch (IllegalArgumentException ex) {
            validationResult.error("aspa.content.structure");
        }
    }

    private void decodeVersion(ValidationResult validationResult, DLTaggedObject tagged) {
        validationResult.rejectIfFalse(tagged.getTagNo() == 0, "aspa.content.structure");
        try {
            this.version = Asn1Util.expect((ASN1Encodable)tagged.getBaseObject(), ASN1Integer.class).intValueExact();
            validationResult.rejectIfFalse(this.version == 1, "aspa.version", String.valueOf(this.version));
        }
        catch (ArithmeticException e) {
            validationResult.error("aspa.version", "out-of-bounds");
        }
    }

    private Asn parseProviderAsn(ASN1Encodable asn1Encodable) {
        return Asn1Util.parseAsId((ASN1Encodable)Asn1Util.expect(asn1Encodable, ASN1Integer.class));
    }
}

