/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.xml.converters.X509ResourceCertificateConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class X509ResourceCertificateConverterTest {
    private XStream xStream;
    private X509ResourceCertificateConverter subject;

    @Before
    public void setUp() {
        this.subject = new X509ResourceCertificateConverter();
        this.xStream = new XStream();
        this.xStream.registerConverter((Converter)this.subject);
        this.xStream.allowTypes(new Class[]{X509ResourceCertificate.class});
    }

    @Test
    public void shouldSupportResourceCertificate() {
        Assert.assertTrue((boolean)this.subject.canConvert(X509ResourceCertificate.class));
    }

    @Test
    public void shouldSerializeResourceCertificate() {
        X509ResourceCertificate certificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        String xml = this.xStream.toXML((Object)certificate);
        Assert.assertEquals((Object)certificate, (Object)this.xStream.fromXML(xml));
        Assert.assertFalse((boolean)xml.contains("java.security.cert.Certificate"));
    }
}

