/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.regex.Pattern;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.xml.converters.ManifestCmsConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ManifestCmsConverterTest {
    private XStream xStream;
    private ManifestCmsConverter subject;
    private String expectedXmlRegEx = "<net\\.ripe\\..*\\.ManifestCms>\n  <encoded>[^<]*</encoded>\n</net\\.ripe\\..*\\.ManifestCms>";

    @Before
    public void setUp() {
        this.subject = new ManifestCmsConverter();
        this.xStream = new XStream();
        this.xStream.registerConverter((Converter)this.subject);
        this.xStream.allowTypes(new Class[]{ManifestCms.class});
    }

    @Test
    public void shouldSupportResourceCertificate() {
        Assert.assertTrue((boolean)this.subject.canConvert(ManifestCms.class));
    }

    @Test
    public void shouldOnlyUseEncodedWhenSerializingManifest() {
        ManifestCms manifestCms = ManifestCmsTest.getRootManifestCms();
        String xml = this.xStream.toXML((Object)manifestCms);
        Assert.assertTrue((boolean)Pattern.matches(this.expectedXmlRegEx, xml));
    }

    @Test
    public void shouldDoRoundTripSerializeAndDesirializeManifest() {
        ManifestCms manifestCms = ManifestCmsTest.getRootManifestCms();
        String xml = this.xStream.toXML((Object)manifestCms);
        ManifestCms processedManifest = (ManifestCms)this.xStream.fromXML(xml);
        Assert.assertEquals((Object)manifestCms, (Object)processedManifest);
    }
}

