/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.util.EnumSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilder;
import net.ripe.rpki.commons.crypto.util.PregeneratedKeyPairFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateParentChildLooseValidator;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateParentChildValidator;
import net.ripe.rpki.commons.validation.properties.IpResourceGen;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitQuickcheck.class)
public class X509ResourceCertificateParentChildValidatorTest {
    private static final X500Principal ROOT_CERTIFICATE_NAME = new X500Principal("CN=For Testing Only, CN=RIPE NCC, C=NL");
    private static final IpResourceSet ROOT_RESOURCE_SET = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/16, ffce::/16, AS21212");
    private static final BigInteger ROOT_SERIAL_NUMBER = BigInteger.valueOf(900L);
    private static final DateTime NOW = UTC.dateTime();
    private static final ValidityPeriod VALIDITY_PERIOD = new ValidityPeriod((ReadableInstant)NOW.minusMinutes(1), (ReadableInstant)NOW.plusYears(1));
    private static final X500Principal FIRST_CHILD_CERTIFICATE_NAME = new X500Principal("CN=For Testing Only, CN=First Child, C=NL");
    private static final BigInteger FIRST_CHILD_SERIAL_NUMBER = ROOT_SERIAL_NUMBER.add(BigInteger.valueOf(1L));
    private static final X500Principal SECOND_CHILD_CERTIFICATE_NAME = new X500Principal("CN=For Testing Only, CN=Second Child, C=NL");
    private static final IpResourceSet INVALID_CHILD_RESOURCE_SET = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/15, ffce::/16, AS21212");
    private static final ValidityPeriod EXPIRED_VALIDITY_PERIOD = new ValidityPeriod((ReadableInstant)NOW.minusMonths(2), (ReadableInstant)NOW.minusMonths(1));
    private static final KeyPair ROOT_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
    private static final KeyPair FIRST_CHILD_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
    private static final KeyPair SECOND_CHILD_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
    private static final ValidationLocation CHILD_VALIDATION_LOCATION = new ValidationLocation("child");
    private X509ResourceCertificate root;
    private X509ResourceCertificate child;
    private X509Crl rootCrl;
    private ValidationResult result;
    private ValidationOptions options;

    @Before
    public void setUp() {
        this.root = this.getRootResourceCertificate();
        this.child = this.createChildCertificateBuilder().build();
        this.rootCrl = this.getRootCRL().build(ROOT_KEY_PAIR.getPrivate());
        this.result = ValidationResult.withLocation((String)"n/a");
        this.options = ValidationOptions.strictValidation();
    }

    private void validate(X509ResourceCertificateParentChildValidator validator, X509ResourceCertificate certificate) {
        String location = "child";
        validator.validate(location, certificate);
    }

    @Test
    public void shouldAcceptHappyFlowChildCertificate() {
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertFalse((boolean)this.result.hasFailures());
    }

    @Test
    public void shouldRejectInvalidSignature() {
        this.child = this.createChildCertificateBuilder().withSigningKeyPair(SECOND_CHILD_KEY_PAIR).build();
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertTrue((boolean)this.result.hasFailureForLocation(CHILD_VALIDATION_LOCATION));
        Assert.assertEquals((Object)"cert.signature", (Object)((ValidationCheck)this.result.getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey());
    }

    @Test
    public void shouldAcceptSelfSignedSignature() {
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.root);
        Assert.assertFalse((boolean)this.result.hasFailures());
    }

    @Test
    public void shouldRejectRevokedCertificate() {
        this.rootCrl = this.getRootCRL().addEntry(FIRST_CHILD_SERIAL_NUMBER, VALIDITY_PERIOD.getNotValidBefore().plusDays(2)).build(ROOT_KEY_PAIR.getPrivate());
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)"cert.not.revoked", (Object)((ValidationCheck)this.result.getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey());
    }

    @Test
    public void shouldRejectIfCrlAbsentForNonRootCertificate() {
        this.rootCrl = null;
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertTrue((boolean)this.result.hasFailures());
    }

    @Test
    public void shouldRejectCertificateWithWrongValidity() {
        this.child = this.createChildCertificateBuilder().withValidityPeriod(EXPIRED_VALIDITY_PERIOD).build();
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)"cert.not.valid.after", (Object)((ValidationCheck)this.result.getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey());
    }

    @Test
    public void shouldRejectInvalidIssuer() {
        this.child = this.createChildCertificateBuilder().withIssuerDN(SECOND_CHILD_CERTIFICATE_NAME).build();
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)"cert.issuer.eq.prev.subject", (Object)((ValidationCheck)this.result.getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey());
    }

    @Test
    public void shouldWarnOnInvalidKeyUsage_wrong_number() {
        this.child = this.createChildCertificateBuilder().withKeyUsage(128).build();
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertFalse((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)this.result.getResult(CHILD_VALIDATION_LOCATION, "cert.key.usage.invalid"), (Object)new ValidationCheck(ValidationStatus.WARNING, "cert.key.usage.invalid", new String[0]));
    }

    @Test
    public void shouldWarnOnInvalidKeyUsage_missing_required_value() {
        this.child = this.createChildCertificateBuilder().withKeyUsage(192).build();
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertFalse((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)this.result.getResult(CHILD_VALIDATION_LOCATION, "cert.key.cert.sign"), (Object)new ValidationCheck(ValidationStatus.WARNING, "cert.key.cert.sign", new String[0]));
    }

    @Test
    public void shouldWarnOnMissingKeyUsage() {
        this.child = this.createChildCertificateBuilder().withKeyUsage(0).build();
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertFalse((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)this.result.getResult(CHILD_VALIDATION_LOCATION, "cert.key.usage.extension.present"), (Object)new ValidationCheck(ValidationStatus.WARNING, "cert.key.usage.extension.present", new String[0]));
    }

    @Test
    public void shouldRejectMissingAuthorityKeyIdentifier() {
        this.child = this.createChildCertificateBuilder().withAuthorityKeyIdentifier(false).build();
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)"cert.aki.present", (Object)((ValidationCheck)this.result.getFailures(CHILD_VALIDATION_LOCATION).get(0)).getKey());
    }

    @Test
    public void shouldRejectInvalidResourceSet() {
        this.child = this.createChildCertificateBuilder().withInheritedResourceTypes(EnumSet.noneOf(IpResourceType.class)).withResources(INVALID_CHILD_RESOURCE_SET).build();
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertTrue((boolean)this.result.hasFailures());
    }

    @Test
    public void shouldRejectInheritedResourcesForSelfSignedCertificate() {
        this.root = this.getRootResourceCertificateWithInheritedResources();
        this.child = this.getRootResourceCertificateWithInheritedResources();
        X509ResourceCertificateParentChildValidator validator = new X509ResourceCertificateParentChildValidator(this.options, this.result, this.root, this.rootCrl, this.root.getResources());
        this.validate(validator, this.child);
        Assert.assertTrue((boolean)this.result.hasFailures());
    }

    @Property
    public void validParentChildSubResources(List<@From(value=IpResourceGen.class) IpResource> parentResources, int childResourceCount) {
        Assume.assumeThat((Object)parentResources.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assume.assumeThat((Object)childResourceCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        IpResourceSet parentResourceSet = new IpResourceSet(parentResources);
        IpResourceSet childResourceSet = new IpResourceSet(parentResources.subList(0, Math.abs(childResourceCount) % parentResources.size()));
        if (childResourceSet.isEmpty()) {
            return;
        }
        ValidationResult result = this.validateParentChildPair(parentResourceSet, childResourceSet);
        Assert.assertFalse((boolean)result.hasFailures());
    }

    @Property
    public void validParentChildOverClaiming(List<@From(value=IpResourceGen.class) IpResource> parentResources, int childResourceCount, List<@From(value=IpResourceGen.class) IpResource> extraChildResources) {
        Assume.assumeThat((Object)parentResources.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        IpResourceSet parentResourceSet = new IpResourceSet(parentResources);
        IpResourceSet childResourceSet = new IpResourceSet(extraChildResources);
        parentResources.subList(0, Math.abs(childResourceCount) % parentResources.size()).forEach(arg_0 -> ((IpResourceSet)childResourceSet).add(arg_0));
        Assume.assumeThat((Object)childResourceSet.isEmpty(), (Matcher)Matchers.is((Object)false));
        ValidationResult result = this.validateParentChildPair(parentResourceSet, childResourceSet);
        if (extraChildResources.isEmpty()) {
            Assert.assertFalse((boolean)result.hasFailures());
        } else {
            IpResourceSet overclaiming = new IpResourceSet(childResourceSet);
            overclaiming.removeAll((Iterable)parentResourceSet);
            if (!overclaiming.isEmpty()) {
                ValidationCheck failure = (ValidationCheck)result.getFailuresForAllLocations().get(0);
                Assert.assertEquals((Object)"cert.resource.range.is.valid", (Object)failure.getKey());
                Assert.assertEquals((Object)overclaiming.toString(), (Object)failure.getParams()[0]);
            }
        }
    }

    @Property
    public void validParentChildOverClaimingLooseValidation(List<@From(value=IpResourceGen.class) IpResource> parentResources, int childResourceCount, List<@From(value=IpResourceGen.class) IpResource> extraChildResources) {
        if (parentResources.isEmpty()) {
            return;
        }
        IpResourceSet parentResourceSet = new IpResourceSet(parentResources);
        IpResourceSet childResourceSet = new IpResourceSet(extraChildResources);
        parentResources.subList(0, Math.abs(childResourceCount) % parentResources.size()).forEach(arg_0 -> ((IpResourceSet)childResourceSet).add(arg_0));
        if (childResourceSet.isEmpty()) {
            return;
        }
        ValidationResult result = this.validateParentChildReconsidered(parentResourceSet, childResourceSet);
        Assert.assertFalse((boolean)result.hasFailures());
        if (!extraChildResources.isEmpty()) {
            IpResourceSet overclaiming = new IpResourceSet(childResourceSet);
            overclaiming.removeAll((Iterable)parentResourceSet);
            if (!overclaiming.isEmpty()) {
                ValidationCheck warning = (ValidationCheck)result.getWarnings().get(0);
                Assert.assertEquals((Object)"cert.resource.range.is.valid", (Object)warning.getKey());
                Assert.assertEquals((Object)overclaiming.toString(), (Object)warning.getParams()[0]);
            }
        }
    }

    private ValidationResult validateParentChildReconsidered(IpResourceSet parentResourceSet, IpResourceSet childResourceSet) {
        return this.validateParentChildPairImpl(parentResourceSet, childResourceSet, true);
    }

    private ValidationResult validateParentChildPair(IpResourceSet parentResourceSet, IpResourceSet childResourceSet) {
        return this.validateParentChildPairImpl(parentResourceSet, childResourceSet, false);
    }

    private ValidationResult validateParentChildPairImpl(IpResourceSet parentResourceSet, IpResourceSet childResourceSet, boolean reconsidered) {
        X509ResourceCertificate parentCertificate = this.createRootCertificateBuilder().withResources(parentResourceSet).build();
        X509ResourceCertificate childCertificate = this.createChildCertificateBuilder().withResources(childResourceSet).withInheritedResourceTypes(EnumSet.noneOf(IpResourceType.class)).build();
        X509Crl rootCrl = this.getRootCRL().build(ROOT_KEY_PAIR.getPrivate());
        ValidationResult result = ValidationResult.withLocation((String)"n/a");
        Object validator = reconsidered ? new X509ResourceCertificateParentChildLooseValidator(this.options, result, rootCrl, new CertificateRepositoryObjectValidationContext(URI.create("rsync://parent.cer"), parentCertificate)) : new X509ResourceCertificateParentChildValidator(this.options, result, parentCertificate, rootCrl, parentResourceSet);
        validator.validate("child.cer", childCertificate);
        return result;
    }

    private X509ResourceCertificate getRootResourceCertificate() {
        return this.createRootCertificateBuilder().build();
    }

    private X509ResourceCertificate getRootResourceCertificateWithInheritedResources() {
        return this.createRootCertificateBuilder().withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class)).withResources(new IpResourceSet()).build();
    }

    private X509ResourceCertificateBuilder createRootCertificateBuilder() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withSubjectDN(ROOT_CERTIFICATE_NAME);
        builder.withIssuerDN(ROOT_CERTIFICATE_NAME);
        builder.withSerial(ROOT_SERIAL_NUMBER);
        builder.withValidityPeriod(VALIDITY_PERIOD);
        builder.withPublicKey(ROOT_KEY_PAIR.getPublic());
        builder.withCa(true);
        builder.withKeyUsage(6);
        builder.withAuthorityKeyIdentifier(true);
        builder.withResources(ROOT_RESOURCE_SET);
        builder.withAuthorityKeyIdentifier(false);
        builder.withSigningKeyPair(ROOT_KEY_PAIR);
        return builder;
    }

    private X509ResourceCertificateBuilder createChildCertificateBuilder() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withSubjectDN(FIRST_CHILD_CERTIFICATE_NAME);
        builder.withIssuerDN(ROOT_CERTIFICATE_NAME);
        builder.withSerial(FIRST_CHILD_SERIAL_NUMBER);
        builder.withPublicKey(FIRST_CHILD_KEY_PAIR.getPublic());
        builder.withAuthorityKeyIdentifier(true);
        builder.withSigningKeyPair(ROOT_KEY_PAIR);
        builder.withCa(true);
        builder.withKeyUsage(6);
        builder.withAuthorityKeyIdentifier(true);
        builder.withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class));
        builder.withValidityPeriod(VALIDITY_PERIOD);
        return builder;
    }

    private X509CrlBuilder getRootCRL() {
        X509CrlBuilder builder = new X509CrlBuilder();
        builder.withIssuerDN(ROOT_CERTIFICATE_NAME);
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)VALIDITY_PERIOD.getNotValidBefore().plusDays(1), (ReadableInstant)UTC.dateTime().plusMonths(1)));
        builder.withNumber(BigInteger.valueOf(1L));
        builder.withAuthorityKeyIdentifier(ROOT_KEY_PAIR.getPublic());
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }
}

