/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import java.util.List;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.roa.Roa;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.validation.roa.AllowedRoute;
import org.assertj.core.api.Assertions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.junit.jupiter.api.Test;

class AllowedRouteTest {
    AllowedRouteTest() {
    }

    @Test
    void testToAllowedRoute_empty() {
        RoaDoa subject = new RoaDoa(Asn.parse((String)"AS0"), List.of());
        Assertions.assertThat((List)AllowedRoute.fromRoas(List.of(subject))).isEmpty();
    }

    @Test
    void testToAllowedRoute_transforms() {
        IpRange testNet1 = IpRange.parse((String)"192.0.2.0/24");
        IpRange testNet2 = IpRange.parse((String)"198.51.100.0/24");
        Asn docAs1 = Asn.parse((String)"AS65536");
        Asn docAs2 = Asn.parse((String)"AS65537");
        RoaDoa subject = new RoaDoa(docAs1, List.of(new RoaPrefix(testNet1, Integer.valueOf(32))));
        RoaDoa subject2 = new RoaDoa(docAs2, List.of(new RoaPrefix(testNet2, Integer.valueOf(24)), new RoaPrefix(testNet2, Integer.valueOf(32))));
        Assertions.assertThat((List)AllowedRoute.fromRoas(List.of(subject))).contains((Object[])new AllowedRoute[]{new AllowedRoute(docAs1, testNet1, 32)});
        Assertions.assertThat((List)AllowedRoute.fromRoas(List.of(subject, subject2))).contains((Object[])new AllowedRoute[]{new AllowedRoute(docAs1, testNet1, 32), new AllowedRoute(docAs2, testNet2, 24), new AllowedRoute(docAs2, testNet2, 32)});
    }

    static final class RoaDoa
    implements Roa {
        private final Asn asn;
        private final List<RoaPrefix> prefixes;
        private final ValidityPeriod validityPeriod = new ValidityPeriod((ReadableInstant)Instant.now(), (ReadableInstant)Instant.now().plus((ReadableDuration)Duration.standardDays((long)365L)));

        public RoaDoa(Asn asn, List<RoaPrefix> prefixes) {
            this.asn = asn;
            this.prefixes = prefixes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoaDoa)) {
                return false;
            }
            RoaDoa other = (RoaDoa)o;
            Asn this$asn = this.getAsn();
            Asn other$asn = other.getAsn();
            if (this$asn == null ? other$asn != null : !this$asn.equals(other$asn)) {
                return false;
            }
            List<RoaPrefix> this$prefixes = this.getPrefixes();
            List<RoaPrefix> other$prefixes = other.getPrefixes();
            if (this$prefixes == null ? other$prefixes != null : !((Object)this$prefixes).equals(other$prefixes)) {
                return false;
            }
            ValidityPeriod this$validityPeriod = this.getValidityPeriod();
            ValidityPeriod other$validityPeriod = other.getValidityPeriod();
            return !(this$validityPeriod == null ? other$validityPeriod != null : !this$validityPeriod.equals(other$validityPeriod));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Asn $asn = this.getAsn();
            result = result * 59 + ($asn == null ? 43 : $asn.hashCode());
            List<RoaPrefix> $prefixes = this.getPrefixes();
            result = result * 59 + ($prefixes == null ? 43 : ((Object)$prefixes).hashCode());
            ValidityPeriod $validityPeriod = this.getValidityPeriod();
            result = result * 59 + ($validityPeriod == null ? 43 : $validityPeriod.hashCode());
            return result;
        }

        public String toString() {
            return "AllowedRouteTest.RoaDoa(asn=" + this.getAsn() + ", prefixes=" + this.getPrefixes() + ", validityPeriod=" + this.getValidityPeriod() + ")";
        }

        public Asn getAsn() {
            return this.asn;
        }

        public List<RoaPrefix> getPrefixes() {
            return this.prefixes;
        }

        public ValidityPeriod getValidityPeriod() {
            return this.validityPeriod;
        }
    }
}

