/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.util.ArrayList;
import java.util.List;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import org.bouncycastle.asn1.ASN1Encodable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoaCmsParserTest {
    public static final Asn TEST_ASN = new Asn(42L);
    public static final RoaPrefix TEST_IPV4_PREFIX_1 = new RoaPrefix(IpRange.parse((String)"10.64.0.0/12"), Integer.valueOf(24));
    public static final RoaPrefix TEST_IPV4_PREFIX_2 = new RoaPrefix(IpRange.parse((String)"10.32.0.0/12"), null);
    public static final RoaPrefix TEST_IPV6_PREFIX = new RoaPrefix(IpRange.parse((String)"2001:0:200::/39"), null);
    public static final byte[] ENCODED_ROA_IP_ADDRESS = new byte[]{48, 8, 3, 3, 4, 10, 64, 2, 1, 24};
    public static final byte[] ENCODED_ROA_IP_ADDRESS_2 = new byte[]{48, 5, 3, 3, 4, 10, 32};
    public static final byte[] ENCODED_ROA_IP_ADDRESS_FAMILY = new byte[]{48, 23, 4, 2, 0, 1, 48, 17, 48, 5, 3, 3, 4, 10, 32, 48, 8, 3, 3, 4, 10, 64, 2, 1, 24};
    public static final byte[] ENCODED_ROA_IP_ADDRESS_FAMILY_SEQUENCE_IPV4 = new byte[]{48, 25, 48, 23, 4, 2, 0, 1, 48, 17, 48, 5, 3, 3, 4, 10, 32, 48, 8, 3, 3, 4, 10, 64, 2, 1, 24};
    public static final byte[] ENCODED_ROA_IP_ADDRESS_FAMILY_SEQUENCE_ALL = new byte[]{48, 43, 48, 23, 4, 2, 0, 1, 48, 17, 48, 5, 3, 3, 4, 10, 32, 48, 8, 3, 3, 4, 10, 64, 2, 1, 24, 48, 16, 4, 2, 0, 2, 48, 10, 48, 8, 3, 6, 1, 32, 1, 0, 0, 2};
    public static final byte[] ENCODED_ROUTE_ORIGIN_ATTESTATION = new byte[]{48, 30, 2, 1, 42, 48, 25, 48, 23, 4, 2, 0, 1, 48, 17, 48, 5, 3, 3, 4, 10, 32, 48, 8, 3, 3, 4, 10, 64, 2, 1, 24};
    private RoaCmsParser parser;
    private List<RoaPrefix> ipv4Prefixes;
    private List<RoaPrefix> allPrefixes;

    @Before
    public void setUp() {
        String location = "test.roa";
        this.parser = new RoaCmsParser();
        this.ipv4Prefixes = new ArrayList<RoaPrefix>();
        this.ipv4Prefixes.add(TEST_IPV4_PREFIX_1);
        this.ipv4Prefixes.add(TEST_IPV4_PREFIX_2);
        this.ipv4Prefixes.sort(RoaPrefix::compareTo);
        this.allPrefixes = new ArrayList<RoaPrefix>(this.ipv4Prefixes);
        this.allPrefixes.add(TEST_IPV6_PREFIX);
        this.parser.parse(location, RoaCmsTest.createRoaCms(this.allPrefixes).getEncoded());
    }

    @Test
    public void shouldParseRoaIpAddress() {
        Assert.assertEquals((Object)TEST_IPV4_PREFIX_1, (Object)this.parser.parseRoaIpAddressFamily(IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ENCODED_ROA_IP_ADDRESS)));
        Assert.assertEquals((Object)TEST_IPV4_PREFIX_2, (Object)this.parser.parseRoaIpAddressFamily(IpResourceType.IPv4, (ASN1Encodable)Asn1Util.decode((byte[])ENCODED_ROA_IP_ADDRESS_2)));
    }

    @Test
    public void shouldParseRoaIpAddressFamily() {
        ArrayList result = new ArrayList();
        this.parser.parseRoaIpAddressFamily(result, (ASN1Encodable)Asn1Util.decode((byte[])ENCODED_ROA_IP_ADDRESS_FAMILY));
        Assert.assertEquals(this.ipv4Prefixes, result);
    }

    @Test
    public void shouldParseRoaIpAddressFamilySequence() {
        Assert.assertEquals(this.ipv4Prefixes, (Object)this.parser.parseRoaIpAddressFamilySequence((ASN1Encodable)Asn1Util.decode((byte[])ENCODED_ROA_IP_ADDRESS_FAMILY_SEQUENCE_IPV4)));
        Assert.assertEquals(this.allPrefixes, (Object)this.parser.parseRoaIpAddressFamilySequence((ASN1Encodable)Asn1Util.decode((byte[])ENCODED_ROA_IP_ADDRESS_FAMILY_SEQUENCE_ALL)));
    }

    @Test
    public void shouldParseRouteOriginAttestation() {
        this.parser.parseRouteOriginAttestation((ASN1Encodable)Asn1Util.decode((byte[])ENCODED_ROUTE_ORIGIN_ATTESTATION));
        RoaCms roa = this.parser.getRoaCms();
        Assert.assertEquals((Object)TEST_ASN, (Object)roa.getAsn());
        Assert.assertEquals(this.ipv4Prefixes, (Object)roa.getPrefixes());
    }
}

