/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.util.EnumSet;
import java.util.TreeMap;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsBuilder;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsParser;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ManifestCmsParserTest {
    public static final X500Principal TEST_DN = new X500Principal("CN=Test");
    public static final KeyPair TEST_KEY_PAIR = KeyPairFactoryTest.TEST_KEY_PAIR;
    public static final DateTime THIS_UPDATE_TIME = new DateTime(2008, 9, 1, 22, 43, 29, 0, DateTimeZone.UTC);
    public static final DateTime NEXT_UPDATE_TIME = new DateTime(2008, 9, 2, 6, 43, 29, 0, DateTimeZone.UTC);
    public static final byte[] FOO_CONTENT = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32};
    public static final byte[] FOO_HASH = new byte[]{-82, 33, 108, 46, -11, 36, 122, 55, -126, -63, 53, -17, -94, 121, -93, -28, -51, -58, 16, -108, 39, 15, 93, 43, -27, -116, 98, 4, -73, -90, 18, -55};
    public static final byte[] BAR_CONTENT = new byte[]{32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
    public static final byte[] BAR_HASH = new byte[]{77, -99, -39, 69, 30, -61, 10, -3, -84, 18, 112, 23, -70, -73, 109, 38, -41, 79, 6, -17, -49, -88, -14, 119, 85, -72, -77, 26, -93, -65, -28, -88};
    public static final byte[] ENCODED_FILE_AND_HASH_1 = new byte[]{48, 41, 22, 4, 102, 111, 111, 49, 3, 33, 0, -82, 33, 108, 46, -11, 36, 122, 55, -126, -63, 53, -17, -94, 121, -93, -28, -51, -58, 16, -108, 39, 15, 93, 43, -27, -116, 98, 4, -73, -90, 18, -55};
    public static final byte[] ENCODED_EMPTY_FILE_LIST = new byte[]{48, 0};
    public static final byte[] ENCODED_FILE_LIST = new byte[]{48, 85, 48, 40, 22, 3, 66, 97, 82, 3, 33, 0, 77, -99, -39, 69, 30, -61, 10, -3, -84, 18, 112, 23, -70, -73, 109, 38, -41, 79, 6, -17, -49, -88, -14, 119, 85, -72, -77, 26, -93, -65, -28, -88, 48, 41, 22, 4, 102, 111, 111, 49, 3, 33, 0, -82, 33, 108, 46, -11, 36, 122, 55, -126, -63, 53, -17, -94, 121, -93, -28, -51, -58, 16, -108, 39, 15, 93, 43, -27, -116, 98, 4, -73, -90, 18, -55};
    public static final byte[] ENCODED_MANIFEST = new byte[]{48, -127, -121, 2, 1, 68, 24, 15, 50, 48, 48, 56, 48, 57, 48, 49, 50, 50, 52, 51, 50, 57, 90, 24, 15, 50, 48, 48, 56, 48, 57, 48, 50, 48, 54, 52, 51, 50, 57, 90, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 48, 85, 48, 40, 22, 3, 66, 97, 82, 3, 33, 0, 77, -99, -39, 69, 30, -61, 10, -3, -84, 18, 112, 23, -70, -73, 109, 38, -41, 79, 6, -17, -49, -88, -14, 119, 85, -72, -77, 26, -93, -65, -28, -88, 48, 41, 22, 4, 102, 111, 111, 49, 3, 33, 0, -82, 33, 108, 46, -11, 36, 122, 55, -126, -63, 53, -17, -94, 121, -93, -28, -51, -58, 16, -108, 39, 15, 93, 43, -27, -116, 98, 4, -73, -90, 18, -55};
    private ManifestCmsParser parser;

    static X509ResourceCertificate createValidManifestEECertificate(KeyPair keyPair) {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withCa(false).withKeyUsage(128).withSubjectDN(TEST_DN).withIssuerDN(TEST_DN).withSerial(BigInteger.ONE);
        builder.withPublicKey(keyPair.getPublic());
        builder.withSigningKeyPair(keyPair);
        builder.withResources(new IpResourceSet());
        builder.withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class));
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)THIS_UPDATE_TIME, (ReadableInstant)NEXT_UPDATE_TIME));
        builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_SIGNED_OBJECT, URI.create("rsync://example.com/repository/manifest.mft"))});
        return builder.build();
    }

    static X509ResourceCertificate createValidManifestEECertificate() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withCa(false).withKeyUsage(128).withSubjectDN(TEST_DN).withIssuerDN(TEST_DN).withSerial(BigInteger.ONE);
        builder.withPublicKey(TEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(TEST_KEY_PAIR);
        builder.withResources(new IpResourceSet());
        builder.withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class));
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)THIS_UPDATE_TIME, (ReadableInstant)NEXT_UPDATE_TIME));
        builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_SIGNED_OBJECT, URI.create("rsync://example.com/repository/manifest.mft"))});
        return builder.build();
    }

    static X509ResourceCertificate createTenSlashEightResourceCertificate() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withCa(false).withKeyUsage(6).withSubjectDN(TEST_DN).withIssuerDN(TEST_DN).withSerial(BigInteger.ONE);
        builder.withPublicKey(TEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(TEST_KEY_PAIR);
        builder.withResources(IpResourceSet.parse((String)"10.0.0.0/8"));
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)THIS_UPDATE_TIME, (ReadableInstant)NEXT_UPDATE_TIME));
        return builder.build();
    }

    @Before
    public void setUp() {
        String location = "unknown.mft";
        this.parser = new ManifestCmsParser();
        DateTimeUtils.setCurrentMillisFixed((long)THIS_UPDATE_TIME.getMillis());
        ManifestCmsBuilder builder = new ManifestCmsBuilder();
        builder.withCertificate(ManifestCmsParserTest.createValidManifestEECertificate()).withManifestNumber(BigInteger.valueOf(68L));
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)THIS_UPDATE_TIME, (ReadableInstant)NEXT_UPDATE_TIME));
        builder.addFile("foo1", FOO_CONTENT);
        builder.addFile("BaR", BAR_CONTENT);
        builder.withSignatureProvider("SunRsaSign");
        this.parser.parse(location, builder.build(TEST_KEY_PAIR.getPrivate()).getEncoded());
    }

    @After
    public void tearDown() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    @Test
    public void shouldDecodeFileAndHash() {
        TreeMap actual = new TreeMap();
        this.parser.decodeFileAndHash(actual, (ASN1Encodable)Asn1Util.decode((byte[])ENCODED_FILE_AND_HASH_1));
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertTrue((boolean)actual.containsKey("foo1"));
        Assert.assertArrayEquals((byte[])FOO_HASH, (byte[])((byte[])actual.get("foo1")));
    }

    @Test
    public void shouldDecodeEmptyFileList() {
        TreeMap actual = new TreeMap();
        this.parser.decodeFileList(actual, (ASN1Encodable)Asn1Util.decode((byte[])ENCODED_EMPTY_FILE_LIST));
        Assert.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    public void shouldDecodeFileList() {
        TreeMap actual = new TreeMap();
        this.parser.decodeFileList(actual, (ASN1Encodable)Asn1Util.decode((byte[])ENCODED_FILE_LIST));
        Assert.assertEquals((long)2L, (long)actual.size());
        Assert.assertTrue((boolean)actual.containsKey("foo1"));
        Assert.assertArrayEquals((byte[])FOO_HASH, (byte[])((byte[])actual.get("foo1")));
        Assert.assertTrue((boolean)actual.containsKey("BaR"));
        Assert.assertArrayEquals((byte[])BAR_HASH, (byte[])((byte[])actual.get("BaR")));
    }

    @Test
    public void shouldDecodeManifest() {
        this.parser.decodeAsn1Content((ASN1Encodable)Asn1Util.decode((byte[])ENCODED_MANIFEST));
        ManifestCms manifest = this.parser.getManifestCms();
        Assert.assertEquals((long)0L, (long)manifest.getVersion());
        Assert.assertEquals((Object)BigInteger.valueOf(68L), (Object)manifest.getNumber());
        Assert.assertEquals((Object)THIS_UPDATE_TIME, (Object)manifest.getThisUpdateTime());
        Assert.assertEquals((Object)NEXT_UPDATE_TIME, (Object)manifest.getNextUpdateTime());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectManifestWithNonInheritEECert() {
        DateTimeUtils.setCurrentMillisFixed((long)THIS_UPDATE_TIME.getMillis());
        ManifestCmsBuilder builder = new ManifestCmsBuilder();
        builder.withCertificate(ManifestCmsParserTest.createTenSlashEightResourceCertificate()).withManifestNumber(BigInteger.valueOf(68L));
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)THIS_UPDATE_TIME, (ReadableInstant)NEXT_UPDATE_TIME));
        builder.addFile("foo1", FOO_CONTENT);
        builder.addFile("BaR", BAR_CONTENT);
        builder.build(TEST_KEY_PAIR.getPrivate());
    }
}

