/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.aspa;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.io.BaseEncoding;
import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.When;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.util.Comparator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCms;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCmsBuilder;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.util.UTC;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitQuickcheck.class)
public class AspaCmsTest {
    private static final KeyPair TEST_KEY_PAIR = KeyPairFactoryTest.TEST_KEY_PAIR;
    private static final X500Principal TEST_DN = new X500Principal("CN=issuer");
    private static final URI TEST_LOCATION = URI.create("rsync://certificate/repository/filename.asa");
    private static final URI TEST_CA_LOCATION = URI.create("rsync://certificate/repository/ca.cer");
    private static final BigInteger ROA_CERT_SERIAL = BigInteger.TEN;
    private static final ImmutableSortedSet<Asn> PROVIDER_AS_SET = ImmutableSortedSet.of((Comparable)Asn.parse((String)"AS65001"), (Comparable)Asn.parse((String)"AS65002"));
    private static final Asn CUSTOMER_ASN = Asn.parse((String)"AS65000");

    @Test
    public void should_reject_creating_aspa_with_empty_provider_as_set() {
        Assertions.assertThatThrownBy(() -> AspaCmsTest.createAspa(CUSTOMER_ASN, (ImmutableSortedSet<Asn>)ImmutableSortedSet.of())).isInstanceOfSatisfying(IllegalArgumentException.class, e -> Assertions.assertThat((String)e.getMessage()).isEqualTo("ProviderASSet must not be empty"));
    }

    @Property(trials=100)
    public void should_generate_aspa(int customerAsId, @When(satisfies="!#_.isEmpty") List<Asn> providerAsIdSet) {
        Asn customerAsn = new Asn(Integer.toUnsignedLong(customerAsId));
        ImmutableSortedSet providerAsSet = (ImmutableSortedSet)providerAsIdSet.stream().collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
        AspaCms cms = AspaCmsTest.createAspa(customerAsn, (ImmutableSortedSet<Asn>)providerAsSet);
        Assert.assertEquals((long)1L, (long)cms.getVersion());
        Assert.assertEquals((Object)customerAsn, (Object)cms.getCustomerAsn());
        Assert.assertEquals((Object)providerAsSet, (Object)cms.getProviderASSet());
        System.out.println(BaseEncoding.base64().encode(cms.getEncoded()));
    }

    public static AspaCms createAspa() {
        return AspaCmsTest.createAspa(CUSTOMER_ASN, PROVIDER_AS_SET);
    }

    public static AspaCms createAspa(Asn customerAsn, ImmutableSortedSet<Asn> providerAsSet) {
        AspaCmsBuilder builder = new AspaCmsBuilder();
        builder.withCertificate(AspaCmsTest.createCertificate(new IpResourceSet(new IpResource[]{customerAsn})));
        builder.withCustomerAsn(customerAsn);
        builder.withProviderASSet(providerAsSet);
        builder.withSignatureProvider("SunRsaSign");
        return builder.build(TEST_KEY_PAIR.getPrivate());
    }

    private static X509ResourceCertificate createCertificate(IpResourceSet resources) {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withCa(false).withIssuerDN(TEST_DN).withSubjectDN(TEST_DN).withSerial(ROA_CERT_SERIAL);
        builder.withPublicKey(TEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(TEST_KEY_PAIR);
        DateTime now = UTC.dateTime();
        builder.withKeyUsage(128);
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)now.minusMinutes(1), (ReadableInstant)now.plusYears(1)));
        builder.withResources(resources);
        builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_SIGNED_OBJECT, TEST_LOCATION)});
        builder.withAuthorityInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS, TEST_CA_LOCATION)});
        return builder.build();
    }
}

