/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import net.ripe.rpki.commons.crypto.cms.RPKISignedDataGenerator;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificateBuilderTest;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.util.Store;
import org.junit.Before;
import org.junit.Test;

public class RPKISignedDataGeneratorTest {
    final RPKISignedDataGenerator rpkiCmsSubject = new RPKISignedDataGenerator();
    final CMSSignedDataGenerator bouncyCmsOriginal = new CMSSignedDataGenerator();
    final CMSAbsentContent cmsAbsentContent = new CMSAbsentContent();

    @Before
    public void setup() throws Exception {
        List<X509Certificate> certificates = Collections.singletonList(ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getCertificate());
        this.rpkiCmsSubject.addCertificates((Store)new JcaCertStore(certificates));
        this.bouncyCmsOriginal.addCertificates((Store)new JcaCertStore(certificates));
    }

    @Test
    public void rpkiSignedDataGeneratorShouldGenerateSignedDataWithDERSequenceContentInfo() throws Exception {
        CMSSignedData rpkiCMS = this.rpkiCmsSubject.generate((CMSTypedData)this.cmsAbsentContent);
        ContentInfo contentInfo = rpkiCMS.toASN1Structure();
        assert (contentInfo.toASN1Primitive() instanceof DERSequence);
        DERSequence signedData = (DERSequence)contentInfo.getContent().toASN1Primitive();
        assert (signedData.getObjectAt(3).toASN1Primitive() instanceof DERTaggedObject);
    }

    @Test
    public void originalBCSignedDataGeneratorShouldGenerateBERSequenceContentInfo() throws Exception {
        CMSSignedData bcCMS = this.bouncyCmsOriginal.generate((CMSTypedData)this.cmsAbsentContent);
        ContentInfo contentInfo = bcCMS.toASN1Structure();
        assert (contentInfo.toASN1Primitive() instanceof BERSequence);
        BERSequence signedData = (BERSequence)contentInfo.getContent().toASN1Primitive();
        assert (signedData.getObjectAt(3).toASN1Primitive() instanceof BERTaggedObject);
    }
}

