/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import net.ripe.rpki.commons.crypto.cms.GenericRpkiSignedObjectParser;
import net.ripe.rpki.commons.util.RepositoryObjectType;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class GenericRpkiSignedObjectParserTest {
    @Test
    void should_parse_aspa() throws IOException {
        GenericRpkiSignedObjectParser parser = this.parse("interop/aspa/GOOD-profile-15-draft-ietf-sidrops-profile-15-sample.asa");
        Assertions.assertThat((Comparable)((RepositoryObjectType)parser.getRepositoryObjectType().get())).isEqualTo((Object)RepositoryObjectType.Aspa);
        Assertions.assertThat((Comparable)parser.getSigningTime()).isEqualTo((Object)DateTime.parse((String)"2023-06-07T09:08:41+00:00"));
    }

    @Disabled(value="Our parser rejects GBR objects: corrupted stream - out of bounds length found: 115 >= 32")
    @Test
    void should_parse_gbr() throws IOException {
        GenericRpkiSignedObjectParser parser = this.parse("conformance/root/goodRealGbrNothingIsWrong.gbr");
        Assertions.assertThat((Comparable)((RepositoryObjectType)parser.getRepositoryObjectType().get())).isEqualTo((Object)RepositoryObjectType.Gbr);
        Assertions.assertThat((Comparable)parser.getSigningTime()).isEqualTo((Object)DateTime.parse((String)"2016-08-19T12:10:32+00:00"));
    }

    @Test
    void should_parse_manifest() throws IOException {
        GenericRpkiSignedObjectParser parser = this.parse("conformance/root/root.mft");
        Assertions.assertThat((Comparable)((RepositoryObjectType)parser.getRepositoryObjectType().get())).isEqualTo((Object)RepositoryObjectType.Manifest);
        Assertions.assertThat((Comparable)parser.getSigningTime()).isEqualTo((Object)DateTime.parse((String)"2013-10-28T21:24:39+00:00"));
    }

    @Test
    void should_parse_roa() throws IOException {
        GenericRpkiSignedObjectParser parser = this.parse("interop/rpkid-objects/nI2bsx18I5mlex8lBpY0WSJUYio.roa");
        Assertions.assertThat((Comparable)((RepositoryObjectType)parser.getRepositoryObjectType().get())).isEqualTo((Object)RepositoryObjectType.Roa);
        Assertions.assertThat((Comparable)parser.getSigningTime()).isEqualTo((Object)DateTime.parse((String)"2011-11-11T01:55:18+00:00"));
    }

    @Test
    void should_parse_generic() throws IOException {
        GenericRpkiSignedObjectParser parser = this.parse("interop/aspa/BAD-profile-13-AS211321-profile-13.asa");
        Assertions.assertThat((Comparable)parser.getSigningTime()).isEqualTo((Object)DateTime.parse((String)"2021-11-11T11:19:00Z"));
        Assertions.assertThat((Comparable)parser.getCertificate().getValidityPeriod().getNotValidBefore()).isEqualTo((Object)DateTime.parse((String)"2021-11-11T11:14:00Z"));
    }

    private GenericRpkiSignedObjectParser parse(String path) throws IOException {
        byte[] bytes = Resources.toByteArray((URL)Resources.getResource((String)path));
        ValidationResult result = ValidationResult.withLocation((String)path);
        GenericRpkiSignedObjectParser parser = new GenericRpkiSignedObjectParser();
        parser.parse(result, bytes);
        Assertions.assertThat((boolean)result.hasFailures()).isFalse();
        return parser;
    }
}

