/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import lombok.NonNull;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import org.joda.time.DateTime;

public class ProvisioningCmsObject {
    private byte[] encodedContent;
    private final X509Certificate cmsCertificate;
    private final Collection<X509Certificate> caCertificates;
    private final X509CRL crl;
    private AbstractProvisioningPayload payload;
    private final DateTime signingTime;

    public ProvisioningCmsObject(byte[] encodedContent, X509Certificate cmsCertificate, Collection<X509Certificate> caCertificates, X509CRL crl, AbstractProvisioningPayload payload, @NonNull DateTime signingTime) {
        if (signingTime == null) {
            throw new NullPointerException("signingTime is marked non-null but is null");
        }
        this.encodedContent = encodedContent;
        this.cmsCertificate = cmsCertificate;
        this.caCertificates = caCertificates;
        this.crl = crl;
        this.payload = payload;
        this.signingTime = signingTime;
    }

    public byte[] getEncoded() {
        return this.encodedContent;
    }

    public X509Certificate getCmsCertificate() {
        return this.cmsCertificate;
    }

    public AbstractProvisioningPayload getPayload() {
        return this.payload;
    }

    public Collection<X509Certificate> getCaCertificates() {
        return this.caCertificates;
    }

    public X509CRL getCrl() {
        return this.crl;
    }

    public DateTime getSigningTime() {
        return this.signingTime;
    }

    public int hashCode() {
        return Arrays.hashCode(this.encodedContent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningCmsObject other = (ProvisioningCmsObject)obj;
        return Arrays.equals(this.encodedContent, other.getEncoded());
    }
}

