/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.rfc3779;

import com.google.common.base.Preconditions;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.ripe.ipresource.ImmutableResourceSet;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceRange;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.commons.crypto.IllegalAsn1StructureException;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtension;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionEncoder;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;

public class ResourceExtensionParser {
    private static final AddressFamily[] SUPPORTED_ADDRESS_FAMILIES = new AddressFamily[]{AddressFamily.IPV4, AddressFamily.IPV6};

    public ResourceExtension parse(X509Certificate certificate) {
        byte[] asnExtension;
        EnumSet<IpResourceType> inheritedResourceTypes = EnumSet.noneOf(IpResourceType.class);
        ImmutableResourceSet.Builder builder = new ImmutableResourceSet.Builder();
        byte[] ipAddressBlocksExtension = certificate.getExtensionValue(ResourceExtensionEncoder.OID_IP_ADDRESS_BLOCKS.getId());
        if (ipAddressBlocksExtension != null) {
            if (!certificate.getCriticalExtensionOIDs().contains(ResourceExtensionEncoder.OID_IP_ADDRESS_BLOCKS.getId())) {
                throw new IllegalAsn1StructureException("id-pe-ipAddrBlocks must be marked as critical.");
            }
            SortedMap<AddressFamily, IpResourceSet> ipResources = this.parseIpAddressBlocks(ipAddressBlocksExtension);
            for (Map.Entry<AddressFamily, IpResourceSet> resourcesByType : ipResources.entrySet()) {
                if (resourcesByType.getValue() == null) {
                    inheritedResourceTypes.add(resourcesByType.getKey().toIpResourceType());
                    continue;
                }
                builder.addAll((Iterable)resourcesByType.getValue());
            }
        }
        if ((asnExtension = certificate.getExtensionValue(ResourceExtensionEncoder.OID_AUTONOMOUS_SYS_IDS.getId())) != null) {
            if (!certificate.getCriticalExtensionOIDs().contains(ResourceExtensionEncoder.OID_AUTONOMOUS_SYS_IDS.getId())) {
                throw new IllegalAsn1StructureException("id-pe-autonomousSysIds must be marked as critical.");
            }
            IpResourceSet asResources = this.parseAsIdentifiers(asnExtension);
            if (asResources == null) {
                inheritedResourceTypes.add(IpResourceType.ASN);
            } else {
                builder.addAll((Iterable)asResources);
            }
        }
        ImmutableResourceSet resources = builder.build();
        return ResourceExtension.of(inheritedResourceTypes, resources);
    }

    public SortedMap<AddressFamily, IpResourceSet> parseIpAddressBlocks(byte[] extension) {
        ASN1Primitive octetString = Asn1Util.decode(extension);
        Asn1Util.expect((ASN1Encodable)octetString, ASN1OctetString.class);
        ASN1OctetString o = (ASN1OctetString)octetString;
        SortedMap<AddressFamily, IpResourceSet> map = this.derToIpAddressBlocks((ASN1Encodable)Asn1Util.decode(o.getOctets()));
        for (AddressFamily family : SUPPORTED_ADDRESS_FAMILIES) {
            if (map.containsKey(family)) continue;
            map.put(family, new IpResourceSet());
        }
        for (AddressFamily addressFamily : map.keySet()) {
            Preconditions.checkArgument((!addressFamily.hasSubsequentAddressFamilyIdentifier() ? 1 : 0) != 0, (Object)"SAFI not supported");
        }
        return map;
    }

    public IpResourceSet parseAsIdentifiers(byte[] extension) {
        ASN1Primitive octetString = Asn1Util.decode(extension);
        Asn1Util.expect((ASN1Encodable)octetString, ASN1OctetString.class);
        ASN1OctetString o = (ASN1OctetString)octetString;
        IpResourceSet[] resources = this.derToAsIdentifiers((ASN1Encodable)Asn1Util.decode(o.getOctets()));
        Preconditions.checkNotNull((Object)resources[1], (Object)"inheritance of resources has not been implemented yet");
        Preconditions.checkArgument((boolean)resources[1].isEmpty(), (Object)"routing domain identifiers (RDI) not supported");
        return resources[0];
    }

    SortedMap<AddressFamily, IpResourceSet> derToIpAddressBlocks(ASN1Encodable der) {
        ASN1Sequence seq = Asn1Util.expect(der, ASN1Sequence.class);
        TreeMap<AddressFamily, IpResourceSet> map = new TreeMap<AddressFamily, IpResourceSet>();
        Preconditions.checkArgument((seq.size() > 0 ? 1 : 0) != 0, (Object)"IPAddrBlocks MUST NOT be empty");
        for (int i = 0; i < seq.size(); ++i) {
            this.derToIpAddressFamily(seq.getObjectAt(i), map);
        }
        return map;
    }

    void derToIpAddressFamily(ASN1Encodable der, SortedMap<AddressFamily, IpResourceSet> map) {
        ASN1Sequence seq = Asn1Util.expect(der, ASN1Sequence.class);
        Preconditions.checkArgument((seq.size() == 2 ? 1 : 0) != 0, (Object)"IpAddressFamily must have exactly two entries: addressFamily and IpAddressChoice");
        AddressFamily addressFamily = AddressFamily.fromDer(seq.getObjectAt(0));
        IpResourceSet resources = this.derToIpAddressChoice(addressFamily.toIpResourceType(), seq.getObjectAt(1));
        map.put(addressFamily, resources);
    }

    IpResourceSet derToIpAddressChoice(IpResourceType type, ASN1Encodable der) {
        if (der instanceof ASN1Null) {
            return null;
        }
        if (der instanceof ASN1Sequence) {
            IpResourceSet result = new IpResourceSet();
            ASN1Sequence seq = (ASN1Sequence)der;
            IpResource previous = null;
            for (int i = 0; i < seq.size(); ++i) {
                IpResource current = this.derToIpAddressOrRange(type, seq.getObjectAt(i));
                if (previous != null) {
                    Preconditions.checkArgument((!previous.adjacent(current) ? 1 : 0) != 0, (Object)"IP resources in extension MUST NOT be adjacent");
                    UniqueIpResource start = current.getStart();
                    Preconditions.checkArgument((previous.getEnd().compareTo((IpResource)start) < 0 ? 1 : 0) != 0, (Object)"addressOrRanges MUST be sorted");
                }
                result.add(current);
                previous = current;
            }
            return result;
        }
        throw new IllegalArgumentException("ASN1Null or ASN1Sequence expected, got: " + der);
    }

    IpResource derToIpAddressOrRange(IpResourceType type, ASN1Encodable der) {
        if (der instanceof ASN1Sequence) {
            return this.derToIpRange(type, der);
        }
        if (der instanceof DERBitString) {
            return Asn1Util.parseIpAddressAsPrefix(type, der);
        }
        throw new IllegalArgumentException("ASN1Sequence or DERBitString expected, got: " + der);
    }

    IpResource derToIpRange(IpResourceType type, ASN1Encodable der) {
        ASN1Sequence sequence = Asn1Util.expect(der, ASN1Sequence.class);
        Preconditions.checkArgument((sequence.size() == 2 ? 1 : 0) != 0, (Object)"IPRange MUST consist of two entries (start and end)");
        IpAddress start = Asn1Util.parseIpAddress(type, sequence.getObjectAt(0), false);
        IpAddress end = Asn1Util.parseIpAddress(type, sequence.getObjectAt(1), true);
        return IpRange.range((IpAddress)start, (IpAddress)end);
    }

    IpResourceRange derToAsRange(ASN1Encodable der) {
        ASN1Sequence seq = Asn1Util.expect(der, ASN1Sequence.class);
        Preconditions.checkArgument((seq.size() == 2 ? 1 : 0) != 0, (Object)"ASN1Sequence with two elements expected");
        return Asn1Util.parseAsId(seq.getObjectAt(0)).upTo((UniqueIpResource)Asn1Util.parseAsId(seq.getObjectAt(1)));
    }

    IpResource derToAsIdOrRange(ASN1Encodable der) {
        if (der instanceof ASN1Integer) {
            return Asn1Util.parseAsId(der);
        }
        if (der instanceof ASN1Sequence) {
            return this.derToAsRange(der);
        }
        throw new IllegalArgumentException("ASN1Integer or ASN1Sequence expected, got: " + der);
    }

    IpResourceSet derToAsIdsOrRanges(ASN1Encodable der) {
        Asn1Util.expect(der, ASN1Sequence.class);
        ASN1Sequence seq = (ASN1Sequence)der;
        IpResourceSet result = new IpResourceSet();
        IpResource previous = null;
        Preconditions.checkArgument((seq.size() > 0 ? 1 : 0) != 0, (Object)"asIdsOrRanges MUST NOT be empty");
        for (int i = 0; i < seq.size(); ++i) {
            IpResource current = this.derToAsIdOrRange(seq.getObjectAt(i));
            if (previous != null) {
                UniqueIpResource start = current.getStart();
                Preconditions.checkArgument((!start.adjacent((IpResource)previous.getEnd()) ? 1 : 0) != 0, (Object)"ASIdOrRange entries MUST NOT be adjacent");
                Preconditions.checkArgument((boolean)start.max(previous.getEnd()).equals((Object)start), (Object)"ASIdOrRange entries MUST be sorted by increasing numeric value");
            }
            result.add(current);
            previous = current;
        }
        return result;
    }

    IpResourceSet derToAsIdentifierChoice(ASN1Encodable der) {
        if (der instanceof ASN1Null) {
            return null;
        }
        if (der instanceof ASN1Sequence) {
            return this.derToAsIdsOrRanges(der);
        }
        throw new IllegalArgumentException("ASN1Null or ASN1Sequence expected, got: " + der);
    }

    IpResourceSet[] derToAsIdentifiers(ASN1Encodable der) {
        Asn1Util.expect(der, ASN1Sequence.class);
        try {
            ASN1Sequence seq = (ASN1Sequence)der;
            Preconditions.checkArgument((seq.size() <= 2 ? 1 : 0) != 0, (Object)"ASN1Sequence with 2 or fewer elements expected");
            IpResourceSet[] result = new IpResourceSet[]{new IpResourceSet(), new IpResourceSet()};
            for (int i = 0; i < seq.size(); ++i) {
                Asn1Util.expect(seq.getObjectAt(i), ASN1TaggedObject.class);
                ASN1TaggedObject tagged = (ASN1TaggedObject)seq.getObjectAt(i);
                Preconditions.checkArgument((tagged.getTagNo() == 0 || tagged.getTagNo() == 1 ? 1 : 0) != 0, (Object)("unknown tag no: " + tagged.getTagNo()));
                Preconditions.checkArgument(((tagged.getTagClass() & 0x80) != 0 ? 1 : 0) != 0, (Object)"element tag is context specific.");
                result[tagged.getTagNo()] = this.derToAsIdentifierChoice((ASN1Encodable)tagged.getExplicitBaseObject());
            }
            return result;
        }
        catch (IllegalStateException e) {
            throw new IllegalAsn1StructureException("Could not parse AsIdentifiers extension", e);
        }
    }
}

