/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.CheckForNull;
import net.ripe.ipresource.IpRange;
import org.apache.commons.lang3.Validate;

public class RoaPrefix
implements Serializable,
Comparable<RoaPrefix> {
    private static final Comparator<RoaPrefix> ROA_PREFIX_COMPARATOR = Comparator.comparing(RoaPrefix::getPrefix).thenComparing(RoaPrefix::getEffectiveMaximumLength, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final long serialVersionUID = 1L;
    private final IpRange prefix;
    @CheckForNull
    private final Integer maximumLength;

    public RoaPrefix(IpRange prefix) {
        this(prefix, null);
    }

    public RoaPrefix(IpRange prefix, Integer maximumLength) {
        Validate.notNull((Object)prefix, (String)"prefix is required", (Object[])new Object[0]);
        Validate.isTrue((boolean)prefix.isLegalPrefix(), (String)"prefix is not a legal prefix", (Object[])new Object[0]);
        Validate.isTrue((maximumLength == null || maximumLength >= prefix.getPrefixLength() && maximumLength <= prefix.getType().getBitSize() ? 1 : 0) != 0, (String)"maximum length not in range", (Object[])new Object[0]);
        this.prefix = prefix;
        this.maximumLength = maximumLength;
    }

    public IpRange getPrefix() {
        return this.prefix;
    }

    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    public int getEffectiveMaximumLength() {
        return this.maximumLength != null ? this.maximumLength.intValue() : this.getPrefix().getPrefixLength();
    }

    @Override
    public int compareTo(RoaPrefix o) {
        return ROA_PREFIX_COMPARATOR.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoaPrefix roaPrefix = (RoaPrefix)o;
        return Objects.equals(this.prefix, roaPrefix.prefix) && Objects.equals(this.getEffectiveMaximumLength(), roaPrefix.getEffectiveMaximumLength());
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.getEffectiveMaximumLength());
    }

    public String toString() {
        return "RoaPrefix(prefix=" + this.getPrefix() + ", maximumLength=" + this.getMaximumLength() + ")";
    }
}

