/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectParser;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;

public class RoaCmsParser
extends RpkiSignedObjectParser {
    private Asn asn;
    private List<RoaPrefix> prefixes = new ArrayList<RoaPrefix>();

    @Override
    public void parse(ValidationResult result, byte[] encoded) {
        super.parse(result, encoded);
        this.validateRoa();
    }

    public boolean isSuccess() {
        return !this.getValidationResult().hasFailureForCurrentLocation();
    }

    public RoaCms getRoaCms() {
        if (!this.isSuccess()) {
            throw new IllegalArgumentException("ROA validation failed: " + this.getValidationResult().getFailuresForCurrentLocation());
        }
        RpkiSignedObjectInfo cmsObjectInfo = new RpkiSignedObjectInfo(this.getEncoded(), this.getResourceCertificate(), this.getContentType(), this.getSigningTime());
        return new RoaCms(cmsObjectInfo, this.asn, this.prefixes);
    }

    private void validateRoa() {
        ValidationResult validationResult = this.getValidationResult();
        if (!validationResult.rejectIfFalse(this.getContentType() != null, "roa.content.type")) {
            return;
        }
        if (!validationResult.rejectIfFalse(RoaCms.CONTENT_TYPE.equals((ASN1Primitive)this.getContentType()), "roa.content.type", this.getContentType().toString())) {
            return;
        }
        IpResourceSet roaPrefixes = new IpResourceSet();
        for (RoaPrefix prefix : Collections.unmodifiableList(this.prefixes)) {
            roaPrefixes.add((IpResource)prefix.getPrefix());
        }
        try {
            validationResult.rejectIfFalse(this.getResourceCertificate().containsResources(roaPrefixes), "roa.resources");
        }
        catch (Exception e) {
            validationResult.rejectIfFalse(false, "roa.resources");
        }
    }

    RoaPrefix parseRoaIpAddressFamily(IpResourceType type, ASN1Encodable der) {
        Asn1Util.expect(der, ASN1Sequence.class);
        ASN1Sequence seq = (ASN1Sequence)der;
        ValidationResult validationResult = this.getValidationResult();
        if (!validationResult.rejectIfFalse(seq.size() > 0 && seq.size() <= 2, "roa.addr.family.contains.prefix")) {
            throw new IllegalArgumentException("ip address family sequence length invalid");
        }
        IpRange prefix = Asn1Util.parseIpAddressAsPrefix(type, seq.getObjectAt(0));
        BigInteger maxLength = null;
        if (seq.size() > 1 && !validationResult.rejectIfFalse((maxLength = Asn1Util.expect(seq.getObjectAt(1), ASN1Integer.class).getValue()).compareTo(BigInteger.ZERO) >= 0 && maxLength.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0, "roa.prefix.length")) {
            throw new IllegalArgumentException("prefix max length invalid");
        }
        return new RoaPrefix(prefix, maxLength == null ? null : Integer.valueOf(maxLength.intValue()));
    }

    void parseRouteOriginAttestation(ASN1Encodable der) {
        ValidationResult validationResult = this.getValidationResult();
        try {
            ASN1Sequence seq = Asn1Util.expect(der, ASN1Sequence.class);
            int itemCount = seq.size();
            if (itemCount == 3) {
                Optional<BigInteger> maybeVersion = RoaCmsParser.getTaggedVersion(0, seq);
                maybeVersion.ifPresentOrElse(version -> {
                    if (validationResult.rejectIfFalse(BigInteger.ZERO.equals(version), "roa.attestation.version", "attestation version must be 0, but is " + version)) {
                        this.asn = Asn1Util.parseAsId(seq.getObjectAt(1));
                        this.prefixes = this.parseRoaIpAddressFamilySequence(seq.getObjectAt(2));
                    }
                }, () -> validationResult.error("roa.attestation.version", "missing/not explicitly tagged"));
            } else if (itemCount == 2) {
                this.asn = Asn1Util.parseAsId(seq.getObjectAt(0));
                this.prefixes = this.parseRoaIpAddressFamilySequence(seq.getObjectAt(1));
            } else {
                validationResult.rejectIfFalse(false, "roa.seq.has.asn.and.prefixes");
            }
        }
        catch (IllegalArgumentException ex) {
            validationResult.error("roa.content.structure");
        }
    }

    void parseRoaIpAddressFamily(List<RoaPrefix> roaPrefixList, ASN1Encodable der) {
        Asn1Util.expect(der, ASN1Sequence.class);
        ASN1Sequence seq = (ASN1Sequence)der;
        ValidationResult validationResult = this.getValidationResult();
        if (seq.size() != 2) {
            validationResult.rejectIfFalse(false, "roa.seq.has.addr.family.and.addressed");
            throw new IllegalArgumentException("ROA sequence does not contain address family and addresses");
        }
        AddressFamily addressFamily = AddressFamily.fromDer(seq.getObjectAt(0));
        if (!addressFamily.equals(AddressFamily.IPV4) && !addressFamily.equals(AddressFamily.IPV6)) {
            validationResult.rejectIfFalse(false, "roa.addr.family.valid");
            throw new IllegalArgumentException("Address family is neither IPv4 nor IPv6");
        }
        Asn1Util.expect(seq.getObjectAt(1), ASN1Sequence.class);
        ASN1Sequence addresses = (ASN1Sequence)seq.getObjectAt(1);
        for (int i = 0; i < addresses.size(); ++i) {
            RoaPrefix roaPrefix;
            try {
                roaPrefix = this.parseRoaIpAddressFamily(addressFamily.toIpResourceType(), addresses.getObjectAt(i));
            }
            catch (IllegalArgumentException e) {
                roaPrefix = null;
            }
            if (roaPrefix == null) continue;
            roaPrefixList.add(roaPrefix);
        }
    }

    List<RoaPrefix> parseRoaIpAddressFamilySequence(ASN1Encodable der) {
        Asn1Util.expect(der, ASN1Sequence.class);
        ASN1Sequence seq = (ASN1Sequence)der;
        ArrayList<RoaPrefix> roaPrefixList = new ArrayList<RoaPrefix>();
        boolean errorOccured = false;
        for (int i = 0; i < seq.size(); ++i) {
            try {
                this.parseRoaIpAddressFamily(roaPrefixList, seq.getObjectAt(i));
                continue;
            }
            catch (IllegalArgumentException e) {
                errorOccured = true;
            }
        }
        ValidationResult validationResult = this.getValidationResult();
        if (!errorOccured) {
            validationResult.rejectIfFalse(true, "roa.seq.has.addr.family.and.addressed");
            validationResult.rejectIfFalse(true, "roa.addr.family.valid");
        }
        validationResult.rejectIfTrue(roaPrefixList.isEmpty(), "roa.prefix.list.not.empty");
        return roaPrefixList;
    }

    @Override
    public void decodeAsn1Content(ASN1Encodable encoded) {
        this.parseRouteOriginAttestation(encoded);
    }
}

