/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import com.google.common.net.UrlEscapers;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObject;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsGeneralInfo;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class ManifestCms
extends RpkiSignedObject {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_VERSION = 0;
    @Deprecated
    public static final String CONTENT_TYPE_OID = "1.2.840.113549.1.9.16.1.26";
    public static final ASN1ObjectIdentifier CONTENT_TYPE = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.26");
    public static final String FILE_HASH_ALGORITHM = CMSSignedDataGenerator.DIGEST_SHA256;
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+\\.[a-z]{3}");
    private final Map<String, byte[]> hashes;
    private final ManifestCmsGeneralInfo manifestCmsGeneralInfo;

    ManifestCms(RpkiSignedObjectInfo cmsObjectData, ManifestCmsGeneralInfo manifestCmsGeneralInfo, Map<String, byte[]> hashes) {
        super(cmsObjectData);
        this.manifestCmsGeneralInfo = manifestCmsGeneralInfo;
        this.hashes = hashes;
    }

    public int getVersion() {
        return this.manifestCmsGeneralInfo.getVersion();
    }

    public BigInteger getNumber() {
        return this.manifestCmsGeneralInfo.getNumber();
    }

    public String getFileHashAlgorithm() {
        return this.manifestCmsGeneralInfo.getFileHashAlgorithm();
    }

    public DateTime getThisUpdateTime() {
        return this.manifestCmsGeneralInfo.getThisUpdateTime();
    }

    public DateTime getNextUpdateTime() {
        return this.manifestCmsGeneralInfo.getNextUpdateTime();
    }

    public int size() {
        return this.hashes.size();
    }

    public boolean containsFile(String fileName) {
        return this.hashes.containsKey(fileName);
    }

    public Map<String, byte[]> getHashes() {
        return this.hashes;
    }

    public Map<String, byte[]> getFiles() {
        return this.getHashes();
    }

    public boolean matchesFiles(Map<String, byte[]> filesToMatch) {
        if (this.hashes.keySet().equals(filesToMatch.keySet())) {
            for (Map.Entry<String, byte[]> entry : this.hashes.entrySet()) {
                byte[] contentToMatch;
                String fileName = entry.getKey();
                if (this.verifyFileContents(fileName, contentToMatch = filesToMatch.get(fileName))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Set<String> getFileNames() {
        return this.hashes.keySet();
    }

    @Override
    public URI getCrlUri() {
        return this.getCertificate().findFirstRsyncCrlDistributionPoint();
    }

    @Override
    protected void validateWithCrl(String location, CertificateRepositoryObjectValidationContext context, ValidationOptions options, ValidationResult result, X509Crl crl) {
        result.setLocation(new ValidationLocation(location));
        this.checkManifestValidityTimes(options, result);
        this.checkEntries(result);
        super.validateWithCrl(location, context, options, result, crl);
    }

    private void checkEntries(ValidationResult result) {
        List failedEntries = this.getFileNames().stream().filter(s -> !FILE_NAME_PATTERN.matcher((CharSequence)s).matches()).collect(Collectors.toList());
        result.rejectIfFalse(failedEntries.isEmpty(), "mf.entry.file.name.is.relative", failedEntries.stream().map(UrlEscapers.urlFormParameterEscaper().asFunction()).collect(Collectors.joining(", ")));
    }

    private void checkManifestValidityTimes(ValidationOptions options, ValidationResult result) {
        DateTime thisUpdateTime = this.getThisUpdateTime();
        DateTime nextUpdateTime = this.getNextUpdateTime();
        result.rejectIfFalse(thisUpdateTime.isBefore((ReadableInstant)nextUpdateTime), "mf.this.update.before.next.update", thisUpdateTime.toString(), nextUpdateTime.toString());
        result.rejectIfTrue(thisUpdateTime.isAfterNow(), "mf.before.this.update", thisUpdateTime.toString());
        if (options.isStrictManifestCRLValidityChecks()) {
            boolean postGracePeriod = nextUpdateTime.plus((ReadableDuration)options.getManifestMaxStalePeriod()).isBeforeNow();
            if (postGracePeriod) {
                result.error("mf.past.next.update", nextUpdateTime.toString());
            } else {
                result.warnIfTrue(nextUpdateTime.isBeforeNow(), "mf.past.next.update", nextUpdateTime.toString());
            }
        } else {
            result.warnIfTrue(nextUpdateTime.isBeforeNow(), "mf.past.next.update", nextUpdateTime.toString());
        }
    }

    @Deprecated
    public byte[] getHash(String fileName) {
        return this.hashes.get(fileName);
    }

    public boolean verifyFileContents(String fileName, byte[] contents) {
        return this.getFileContentSpecification(fileName).isSatisfiedBy(contents);
    }

    public FileContentSpecification getFileContentSpecification(String fileName) {
        Validate.isTrue((boolean)this.containsFile(fileName));
        return new FileContentSpecification(this.getHash(fileName));
    }

    public static byte[] hashContents(byte[] contents) {
        SHA256Digest digest = new SHA256Digest();
        digest.update(contents, 0, contents.length);
        byte[] digestValue = new byte[digest.getDigestSize()];
        digest.doFinal(digestValue, 0);
        return digestValue;
    }

    public static class FileContentSpecification
    implements Specification<byte[]> {
        private byte[] hash;

        public FileContentSpecification(byte[] hash) {
            this.hash = Arrays.copyOf(hash, hash.length);
        }

        public byte[] getHash() {
            return Arrays.copyOf(this.hash, this.hash.length);
        }

        @Override
        public boolean isSatisfiedBy(byte[] contents) {
            return Arrays.equals(this.hash, ManifestCms.hashContents(contents));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.hash);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileContentSpecification other = (FileContentSpecification)obj;
            return Arrays.equals(this.hash, other.hash);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("hash", this.hash).toString();
        }
    }
}

