/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.interop;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BBNConformanceTest {
    private static final String PATH_TO_BBN_OBJECTS = "src/test/resources/conformance/";

    @Test
    public void shouldParseAllObjects() throws IOException {
        AtomicInteger objectCount = new AtomicInteger();
        AtomicInteger errorCount = new AtomicInteger();
        AtomicInteger exceptionCount = new AtomicInteger();
        PathMatcher extensionMatcher = FileSystems.getDefault().getPathMatcher("glob:**.{cer,crl,mft,roa}");
        try (Stream<Path> paths = Files.find(new File(PATH_TO_BBN_OBJECTS).toPath(), Integer.MAX_VALUE, (p, attr) -> extensionMatcher.matches((Path)p), new FileVisitOption[0]);){
            paths.forEach(path -> {
                objectCount.incrementAndGet();
                try {
                    byte[] encoded = Files.readAllBytes(path);
                    ValidationResult result = ValidationResult.withLocation((String)path.getFileName().toString());
                    CertificateRepositoryObject res = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)result);
                    Assertions.assertThat((result.hasFailures() || res != null ? 1 : 0) != 0).isTrue();
                    if (result.hasFailures() && path.getFileName().startsWith("good")) {
                        System.err.println("Supposed to be good: " + path.getFileName());
                        errorCount.incrementAndGet();
                    } else if (!result.hasFailures() && path.getFileName().startsWith("bad")) {
                        System.err.println("Supposed to be bad: " + path.getFileName());
                        errorCount.incrementAndGet();
                    } else {
                        System.out.println(path.getFileName() + " -> " + result.hasFailures());
                    }
                }
                catch (IOException | RuntimeException ex) {
                    System.err.println("Exception while parsing " + path.getFileName());
                    exceptionCount.incrementAndGet();
                }
            });
        }
        System.out.println(objectCount + " objects: " + errorCount + " errors, " + exceptionCount + " exceptions");
    }
}

