/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.util;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import net.ripe.rpki.commons.crypto.util.SignedObjectUtil;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class SignedObjectUtilTest {
    @DisplayName(value="Should parse the file creation time from RPKI objects")
    @ParameterizedTest(name="{index} => {0} filename={1} expected-creation-time={3} path={2}")
    @CsvSource(value={"ASPA, sample.asa, interop/aspa/GOOD-profile-15-draft-ietf-sidrops-profile-15-sample.asa, 2023-06-07T09:08:41Z", "Manifest, sample.mft, conformance/root/root.mft, 2013-10-28T21:24:39Z", "ROA, sample.roa, interop/rpkid-objects/nI2bsx18I5mlex8lBpY0WSJUYio.roa, 2011-11-11T01:55:18Z", "'Generic signed object (that does not match object profile)', generic-signed-object.gbr, interop/aspa/BAD-profile-13-AS211321-profile-13.asa, 2021-11-11T11:19:00Z", "router certificate, router.cer, router/router_certificate.cer, 2017-12-06T18:50:59Z"})
    void shouldParseObject(String description, String fileName, String path, String modified) throws IOException, SignedObjectUtil.NoTimeParsedException {
        Instant creationTime = SignedObjectUtil.getFileCreationTime((URI)URI.create(fileName), (byte[])Resources.toByteArray((URL)Resources.getResource((String)path)));
        Assertions.assertThat((Comparable)creationTime).isEqualTo((Object)DateTime.parse((String)modified));
    }

    @Test
    void shouldThrowOnUnknown_payload() {
        Assertions.assertThatThrownBy(() -> SignedObjectUtil.getFileCreationTime((URI)URI.create("foo.cer"), (byte[])new byte[]{-34, -83, -66, -17})).isInstanceOf(SignedObjectUtil.NoTimeParsedException.class);
    }

    @Test
    void shouldThrowOnUnknown_extension() {
        Assertions.assertThatThrownBy(() -> SignedObjectUtil.getFileCreationTime((URI)URI.create("foo.xxx"), (byte[])Resources.toByteArray((URL)Resources.getResource((String)"interop/aspa/BAD-profile-13-AS211321-profile-13.asa")))).isInstanceOf(SignedObjectUtil.NoTimeParsedException.class);
    }
}

