/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectBuilder;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectValidator;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import net.ripe.rpki.commons.provisioning.payload.list.request.ResourceClassListQueryPayloadBuilder;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificateBuilderTest;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateBuilderTest;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ProvisioningCmsObjectValidatorTest {
    private ProvisioningCmsObjectValidator subject;
    private ValidationOptions options = ValidationOptions.strictValidation();

    @BeforeEach
    public void setUp() throws Exception {
        this.subject = new ProvisioningCmsObjectValidator(this.options, Optional.empty(), ProvisioningObjectMother.createResourceClassListQueryProvisioningCmsObject(), ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT);
    }

    @Test
    public void shouldValidateValidObject() {
        ValidationResult validationResult = ValidationResult.withLocation((String)"n/a");
        this.subject.validate(validationResult);
        Assertions.assertThat((boolean)validationResult.hasFailures()).isFalse();
    }

    @Test
    public void shouldHaveValidatedLocationsForAllObjects() {
        ValidationResult validationResult = ValidationResult.withLocation((String)"n/a");
        this.subject.validate(validationResult);
        Set validatedLocations = validationResult.getValidatedLocations();
        Assertions.assertThat((Collection)validatedLocations).contains((Object[])new ValidationLocation[]{new ValidationLocation("<cms>")});
        Assertions.assertThat((Collection)validatedLocations).contains((Object[])new ValidationLocation[]{new ValidationLocation("<crl>")});
        Assertions.assertThat((Collection)validatedLocations).contains((Object[])new ValidationLocation[]{new ValidationLocation("<cms-cert>")});
        Assertions.assertThat((Collection)validatedLocations).contains((Object[])new ValidationLocation[]{new ValidationLocation("<identity-cert>")});
    }

    @Test
    public void shouldStopIfCmsObjectIsBadlyFormatted() {
        ValidationResult validationResult = ValidationResult.withLocation((String)"n/a");
        this.subject = new ProvisioningCmsObjectValidator(this.options, Optional.empty(), new ProvisioningCmsObject(new byte[]{0}, null, null, null, null, DateTime.now()), ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT);
        this.subject.validate(validationResult);
        Assertions.assertThat((boolean)validationResult.hasFailures()).isTrue();
    }

    @Disabled(value="Test content does not appear to match test name")
    @Test
    public void shouldFailIfCmsObjectDoesNotContainAnyCACertificate() {
        ValidationResult validationResult = ValidationResult.withLocation((String)"n/a");
        ProvisioningCmsObjectBuilder builder = new ProvisioningCmsObjectBuilder().withCmsCertificate(ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getCertificate()).withPayloadContent((AbstractProvisioningPayload)new ResourceClassListQueryPayloadBuilder().build()).withCrl(ProvisioningObjectMother.CRL);
        this.subject = new ProvisioningCmsObjectValidator(this.options, Optional.empty(), builder.build(ProvisioningCmsCertificateBuilderTest.EE_KEYPAIR.getPrivate()), ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT);
        Assertions.assertThatThrownBy(() -> this.subject.validate(validationResult)).isInstanceOf(NullPointerException.class);
        Assertions.assertThat((boolean)validationResult.hasFailures()).isFalse();
    }

    @Disabled(value="Test content does not appear to match test name")
    @Test
    public void shouldFaiIfCmsObjectContainsMultipleCACertificate() {
        ValidationResult validationResult = ValidationResult.withLocation((String)"n/a");
        ProvisioningCmsObjectBuilder builder = new ProvisioningCmsObjectBuilder().withCmsCertificate(ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getCertificate()).withPayloadContent((AbstractProvisioningPayload)new ResourceClassListQueryPayloadBuilder().build()).withCrl(ProvisioningObjectMother.CRL);
        Assertions.assertThatThrownBy(() -> new ProvisioningCmsObjectValidator(this.options, Optional.empty(), builder.build(ProvisioningCmsCertificateBuilderTest.EE_KEYPAIR.getPrivate()), ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT)).hasCauseInstanceOf(NullPointerException.class);
    }
}

