/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.interop;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class BBNRoaConformanceTest {
    private static final String PATH_TO_BBN_OBJECTS = "src/test/resources/conformance/";

    @Test
    public void shouldParseRoaWithMissingSignature() throws IOException {
        boolean hasFailure = this.parseRoa("root/badCMSSigInfoNoSig.roa");
        Assertions.assertThat((boolean)hasFailure).isTrue();
    }

    @Test
    public void shouldParseRoaWithNoSignerInfo() throws IOException {
        boolean hasFailure = this.parseRoa("root/badCMSNoSigInfo.roa");
        Assertions.assertThat((boolean)hasFailure).isTrue();
    }

    @CsvSource(value={"557, VersionV1Explicit, # explicit V1 version (int 0) applied before signature 6482#3", "558, VersionV1ExplicitBadSig, # explicit V1 version (int 0) applied after signature 6482#3", "559, VersionV2, # Version V2 (int 1) 6482#3.1"})
    @ParameterizedTest(name="{displayName} - {0} {1} {2}")
    public void shouldRejectBadRoaObject(String testNumber, String testCaseFile, String testCaseDescription) throws IOException {
        String fileName = String.format("root/badROA%s.roa", testCaseFile);
        Assertions.assertThat((boolean)this.parseRoa(fileName)).isTrue().withFailMessage("[" + testNumber + "] Should reject certificate with " + testCaseDescription + " from " + fileName, new Object[0]);
    }

    private boolean parseRoa(String roa) throws IOException {
        File file = new File(PATH_TO_BBN_OBJECTS, roa);
        byte[] encoded = Files.toByteArray((File)file);
        ValidationResult result = ValidationResult.withLocation((String)file.getName());
        new RoaCmsParser().parse(result, encoded);
        return result.hasFailures();
    }
}

