/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.interop;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class BBNCertificateConformanceTest {
    private static final String PATH_TO_BBN_OBJECTS = "src/test/resources/conformance/";

    @Disabled(value="Early ripe ncc ta certificates have crldp set")
    @Test
    public void shouldRejectSelfSignedCertificateWithCRLDP() throws IOException {
        boolean hasFailure = this.parseCertificate("badRootBadCRLDP.cer");
        Assertions.assertThat((boolean)hasFailure).isTrue();
    }

    @Test
    public void shouldRejectCertificateWithCRLDPWithReasonFieldNotOmitted() throws IOException {
        boolean hasFailure = this.parseCertificate("root/badCertCRLDPReasons.cer");
        Assertions.assertThat((boolean)hasFailure).isTrue();
    }

    @Test
    public void shouldRejectCertificateWithCRLDPWithCrlIssuer() throws IOException {
        boolean hasFailure = this.parseCertificate("root/badCertCRLDPCrlIssuer.cer");
        Assertions.assertThat((boolean)hasFailure).isTrue();
    }

    @Test
    public void shouldRejectCertificateWithoutKeyUsageBit() throws IOException {
        Assertions.assertThat((boolean)this.parseCertificate("root/badCertNoKeyUsage.cer")).isTrue();
    }

    @Test
    public void shouldRejectCertificateWithTwoKeyUsageBits() throws IOException {
        Assertions.assertThat((boolean)this.parseCertificate("root/badCert2KeyUsage.cer")).isTrue();
    }

    @CsvSource(value={"127, KUsageExtra,          has disallowed key usage bit (nonRepudiation) 6487#4.8.4", "217, KUsageDigitalSig,     has disallowed key usage bit (digitalSignature) 6487#4.8.4", "128, KUsageNoCertSign,     lacks bit for signing certificates 6487#4.8.4", "129, KUsageNoCrit,         key usage extension not critical 6487#4.8.4", "131, KUsageNoCRLSign,      lacks bit for signing CRLs 6487#4.8.4"})
    @ParameterizedTest(name="{displayName} - {0} {1} {2}")
    public void shouldRejectCertificateWithIncorrectKeyUsageBits(String testCasenumber, String testCaseFile, String testCaseDescription) throws IOException {
        String fileName = String.format("root/badCert%s.cer", testCaseFile);
        Assertions.assertThat((boolean)this.parseCertificate(fileName)).isTrue().withFailMessage("Should reject certificate with " + testCaseDescription + " from " + fileName, new Object[0]);
    }

    @CsvSource(value={"218, ResourcesIP6Inherit, # (good) inherit IPv6 resources only, others explicit 6487#4.8.10", "219, ResourcesIP4Inherit, # (good) inherit IPv4 resources only, others explicit 6487#4.8.10", "220, ResourcesASInherit, # (good) inherit AS resources only, others explicit 6487#4.8.11", "221, ResourcesAllInherit, # (good) inherit all resources 6487#4.8.10", "222, ResourcesIP6InhOnly, # (good) inherit IPv6 resources only, others not present 6487#4.8.10", "223, ResourcesIP4InhOnly, # (good) inherit IPv4 resources only, others not present 6487#4.8.10", "224, ResourcesASInhOnly, # (good) inherit AS resources only, others not present 6487#4.8.11"})
    @ParameterizedTest(name="{displayName} - {0} {1} {2}")
    public void shouldAcceptCertificateWithResourceExtension(String testCasenumber, String testCaseFile, String testCaseDescription) throws IOException {
        String fileName = String.format("root/goodCert%s.cer", testCaseFile);
        Assertions.assertThat((boolean)this.parseCertificate(fileName)).isFalse().withFailMessage("Should accept certificate with " + testCaseDescription + " from " + fileName, new Object[0]);
    }

    @CsvSource(value={"138, ResourcesASNoCrit, # AS number extension not critical 6487#4.8.11", "139, ResourcesBadAFI, # invalid IP address family 6487#4.8.10, IANA address-family-numbers", "140, ResourcesBadASOrder, # AS numbers out of order 3779 (but full set is pending)", "141, ResourcesBadV4Order, # IPv4 addresses out of order 3779 (but full set is pending)", "142, ResourcesBadV6Order, # IPv6 addresses out of order 3779 (but full set is pending)", "143, ResourcesIPNoCrit, # IP address extension not critical 6487#4.8.10", "144, ResourcesNone, # neither AS nor IP 3779 extensions 6487#4.8.10", "192, ResourcesIPEmpty, # empty set of IP addresses 6487#4.8.10", "193, ResourcesASEmpty, # empty set of AS numbers 6487#4.8.11", "145, ResourcesSAFI, # IP addresses has SAFI digit 6487#4.8.10"})
    @ParameterizedTest(name="{displayName} - {0} {1} {2}")
    public void shouldRejectCertificateWithInvalidResourceExtension(String testCasenumber, String testCaseFile, String testCaseDescription) throws IOException {
        String fileName = String.format("root/badCert%s.cer", testCaseFile);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Assertions.assertThat((boolean)this.parseCertificate(fileName)).isFalse()).isInstanceOfAny(new Class[]{IllegalArgumentException.class, IllegalStateException.class, AssertionError.class})).withFailMessage("Should reject certificate with " + testCaseDescription + " from " + fileName, new Object[0]);
    }

    private boolean certificateHasWarningOrFailure(String certificate) throws IOException {
        File file = new File(PATH_TO_BBN_OBJECTS, certificate);
        byte[] encoded = Files.toByteArray((File)file);
        ValidationResult result = ValidationResult.withLocation((String)file.getName());
        X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
        parser.parse(result, encoded);
        if (!result.hasFailures()) {
            parser.getCertificate();
        }
        return result.hasFailures() || result.hasWarnings();
    }

    private boolean parseCertificate(String certificate) throws IOException {
        File file = new File(PATH_TO_BBN_OBJECTS, certificate);
        byte[] encoded = Files.toByteArray((File)file);
        ValidationResult result = ValidationResult.withLocation((String)file.getName());
        X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
        parser.parse(result, encoded);
        if (!result.hasFailures()) {
            parser.getCertificate();
        }
        return result.hasFailures();
    }
}

