/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.UnknownCertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCms;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCmsTest;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlTest;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.util.RepositoryObjectType;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class CertificateRepositoryObjectFactoryTest {
    @Test
    public void unknownFileExtensionsShouldProduceAnError() {
        byte[] encoded = new byte[]{0, 1};
        String unknownFileExtension = "file.unknown";
        ValidationResult validationResult = ValidationResult.withLocation((String)unknownFileExtension);
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isInstanceOf(UnknownCertificateRepositoryObject.class);
        Assertions.assertThat((byte[])encoded).isEqualTo((Object)object.getEncoded());
        Assertions.assertThat((boolean)validationResult.hasWarnings()).isFalse();
        Assertions.assertThat((boolean)validationResult.hasFailures()).isTrue();
        Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(1);
        ValidationCheck check = validationResult.getResultForCurrentLocation("known.object.type");
        Assertions.assertThat((Comparable)check.getStatus()).isEqualTo((Object)ValidationStatus.ERROR);
        Assertions.assertThat((boolean)Arrays.asList(check.getParams()).contains(unknownFileExtension));
    }

    @Test
    public void shouldParseResourceCertificate() {
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("certificate.cer"));
        X509ResourceCertificate cert = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])cert.getEncoded(), (ValidationResult)validationResult);
        Assertions.assertThat((boolean)validationResult.hasFailureForCurrentLocation()).isFalse().withFailMessage("no validation failures " + validationResult.getFailuresForCurrentLocation(), new Object[0]);
        Assertions.assertThat((Object)object).isInstanceOf(X509ResourceCertificate.class);
        Assertions.assertThat((Object)cert).isEqualTo((Object)object);
        Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(32);
        Assertions.assertThat((boolean)validationResult.hasNoFailuresOrWarnings()).isTrue();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("cert.parsed").isOk()).isTrue();
    }

    @Test
    public void shouldParseMalformedResourceCertificate() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("certificate.cer"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isNull();
        Assertions.assertThat((int)validationResult.getAllValidationChecksForCurrentLocation().size()).isEqualTo(2);
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("cert.parsed").isOk()).isFalse();
    }

    @Test
    public void shouldParseRoaCms() {
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("roa.roa"));
        RoaCms roaCms = RoaCmsTest.getRoaCms();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])roaCms.getEncoded(), (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isInstanceOf(RoaCms.class);
        Assertions.assertThat((Object)roaCms).isEqualTo((Object)object);
        Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(64);
        Assertions.assertThat((boolean)validationResult.hasFailures()).isFalse();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
        Assertions.assertThat((Comparable)validationResult.getResultForCurrentLocation("cert.crldp.omitted").getStatus()).isEqualTo((Object)ValidationStatus.WARNING);
    }

    @Test
    public void shouldParseMalformedRoaCms() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("roa.roa"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isNull();
        Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(3);
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("cms.signed.data.parsing").isOk()).isFalse();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("roa.content.type").isOk()).isFalse();
    }

    @Test
    public void shouldParseManifestCms() {
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("manifest.mft"));
        ManifestCms manifestCms = ManifestCmsTest.getRootManifestCms();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])manifestCms.getEncoded(), (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isInstanceOf(ManifestCms.class);
        Assertions.assertThat((Object)manifestCms).isEqualTo((Object)object);
        Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(67);
        Assertions.assertThat((boolean)validationResult.hasNoFailuresOrWarnings()).isTrue().withFailMessage("" + validationResult.getAllValidationChecksForCurrentLocation(), new Object[0]);
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
    }

    @Test
    public void shouldParseMalformedManifestCms() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("manifest.mft"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isNull();
        Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(2);
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("cms.signed.data.parsing").isOk()).isFalse();
    }

    @Test
    public void shouldParseCrl() {
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("crl.crl"));
        X509Crl crl = X509CrlTest.createCrl();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])crl.getEncoded(), (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isInstanceOf(X509Crl.class);
        Assertions.assertThat((Object)crl).isEqualTo((Object)object);
        Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(2);
        Assertions.assertThat((boolean)validationResult.hasNoFailuresOrWarnings()).isTrue();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("crl.parsed").isOk()).isTrue();
    }

    @Test
    public void shouldParseMalformedCrl() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("crl.crl"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isNull();
        Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(2);
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("crl.parsed").isOk()).isFalse();
    }

    @Test
    public void shouldParseMalformedGhostbustersRecord() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("ghostbusters.gbr"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isNull();
        Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(3);
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
    }

    @Test
    public void shouldParseAspa() {
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("aspa.asa"));
        AspaCms aspa = AspaCmsTest.createAspa();
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])aspa.getEncoded(), (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isInstanceOf(AspaCms.class);
        Assertions.assertThat((Object)aspa).isEqualTo((Object)object);
        ((ListAssert)Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(63)).withFailMessage("" + validationResult.getAllValidationChecksForCurrentLocation(), new Object[0]);
        Assertions.assertThat((boolean)validationResult.hasNoFailuresOrWarnings()).isTrue().withFailMessage("" + validationResult.getAllValidationChecksForCurrentLocation(), new Object[0]);
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("aspa.customer.asn.certified").isOk()).isTrue();
    }

    @Test
    public void shouldParseMalformedAspa() {
        byte[] encoded = new byte[]{0, 1};
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation("aspa.asa"));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isNull();
        ((ListAssert)Assertions.assertThat((List)validationResult.getAllValidationChecksForCurrentLocation()).hasSize(3)).withFailMessage("" + validationResult.getAllValidationChecksForCurrentLocation(), new Object[0]);
        Assertions.assertThat((boolean)validationResult.hasNoFailuresOrWarnings()).isFalse().withFailMessage("" + validationResult.getAllValidationChecksForCurrentLocation(), new Object[0]);
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isTrue();
    }

    @ParameterizedTest(name="{index} => {0} type={1} path={2}")
    @CsvSource(value={"TrustAnchorKey,interop/openbsd-regress/05F53BCE4DAA11EDB9AC0C5B9E174E93.tak", "TrustAnchorKey,interop/openbsd-regress/42AE70A64DA711EDB37796549E174E93.tak", "TrustAnchorKey,interop/openbsd-regress/B7C2334E4DA911EDAF862D5A9E174E93.tak", "SignedChecklist,interop/openbsd-regress/c6938fc00af6496d9d4e6e2d876e4b4811887b60f4f1bc9cd0b3cdb7c57c6d5e.sig", "SignedChecklist,interop/openbsd-regress/checklist-08.sig"})
    public void shouldParseUnsupportedFiles(String type, String path) throws IOException {
        Assertions.assertThat((Comparable)RepositoryObjectType.parse((String)path)).isEqualTo((Object)RepositoryObjectType.valueOf((String)type));
        byte[] encoded = Resources.toByteArray((URL)Resources.getResource((String)path));
        ValidationResult validationResult = ValidationResult.withLocation((ValidationLocation)new ValidationLocation(path));
        CertificateRepositoryObject object = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])encoded, (ValidationResult)validationResult);
        Assertions.assertThat((Object)object).isNotNull();
        Assertions.assertThat((Object)object).isInstanceOf(UnknownCertificateRepositoryObject.class);
        Assertions.assertThat((boolean)validationResult.getResultForCurrentLocation("known.object.type").isOk()).isFalse();
    }
}

