/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.crl;

import java.math.BigInteger;
import java.security.KeyPair;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilder;
import net.ripe.rpki.commons.crypto.crl.X509CrlValidator;
import net.ripe.rpki.commons.crypto.util.PregeneratedKeyPairFactory;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapper;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class X509CrlValidatorTest {
    private static final X500Principal ROOT_CERTIFICATE_NAME = new X500Principal("CN=For Testing Only, CN=RIPE NCC, C=NL");
    private static final IpResourceSet ROOT_RESOURCE_SET = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/16, ffce::/16, AS21212");
    private static final BigInteger ROOT_SERIAL_NUMBER = BigInteger.valueOf(900L);
    private static final ValidityPeriod VALIDITY_PERIOD;
    private static final KeyPair ROOT_KEY_PAIR;
    private static final KeyPair FIRST_CHILD_KEY_PAIR;
    private X509CrlValidator subject;
    private X509ResourceCertificate parent;
    private ValidationOptions options;
    private ValidationResult result;

    @Before
    public void setUp() {
        this.parent = this.getRootResourceCertificate();
        this.options = ValidationOptions.backCompatibleRipeNccValidator();
        this.result = ValidationResult.withLocation((String)"location");
        this.subject = new X509CrlValidator(this.options, this.result, (AbstractX509CertificateWrapper)this.parent);
    }

    @Test
    public void shouldValidateHappyflowCrl() {
        X509Crl crl = this.getRootCRL().build(ROOT_KEY_PAIR.getPrivate());
        this.subject.validate("location", crl);
        this.result = this.subject.getValidationResult();
        Assert.assertFalse((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)new ValidationLocation("location"), (Object)this.result.getCurrentLocation());
    }

    @Test
    public void shouldRejectCrlSignedByOthers() {
        X509Crl crl = this.getRootCRL().build(FIRST_CHILD_KEY_PAIR.getPrivate());
        this.subject.validate("location", crl);
        this.result = this.subject.getValidationResult();
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "cert.crl.signature", new String[0]), (Object)this.result.getResult(new ValidationLocation("location"), "cert.crl.signature"));
    }

    @Test
    public void shouldRejectWhenThisUpdateInFuture() {
        DateTime now = UTC.dateTime().withMillisOfSecond(0);
        DateTime thisUpdateTime = now.plusDays(2);
        DateTime nextUpdateTime = now.plusDays(4);
        X509Crl crl = this.getRootCRL().withValidityPeriod(new ValidityPeriod((ReadableInstant)thisUpdateTime, (ReadableInstant)nextUpdateTime)).build(ROOT_KEY_PAIR.getPrivate());
        this.subject.validate("location", crl);
        this.result = this.subject.getValidationResult();
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "crl.this.update.after.now", new String[]{thisUpdateTime.toString()}), (Object)this.result.getResult(new ValidationLocation("location"), "crl.this.update.after.now"));
    }

    @Test
    public void shouldWarnWhenNextUpdatePassedWithinMaxStaleDays() {
        this.options = ValidationOptions.withStaleConfigurations((Duration)Duration.standardDays((long)1L), (Duration)Duration.ZERO);
        ValidityPeriod newValidity = new ValidityPeriod((ReadableInstant)this.getRootCRL().getThisUpdateTime(), (ReadableInstant)UTC.dateTime().minusSeconds(1).withMillisOfSecond(0));
        X509Crl crl = this.getRootCRL().withValidityPeriod(newValidity).build(ROOT_KEY_PAIR.getPrivate());
        this.subject.validate("location", crl);
        this.result = this.subject.getValidationResult();
        Assert.assertFalse((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.WARNING, "crl.next.update.before.now", new String[]{newValidity.getNotValidAfter().toString()}), (Object)this.result.getResult(new ValidationLocation("location"), "crl.next.update.before.now"));
    }

    @Test
    public void shouldRejectWhenNextUpdateOutsideMaxStaleDays() {
        this.options = ValidationOptions.withStaleConfigurations((Duration)Duration.standardDays((long)1L), (Duration)Duration.ZERO);
        this.subject = new X509CrlValidator(this.options, this.result, (AbstractX509CertificateWrapper)this.parent);
        DateTime nextUpdateTime = UTC.dateTime().minusDays(2).withMillisOfSecond(0);
        X509Crl crl = this.getRootCRL().withNextUpdateTime(nextUpdateTime).build(ROOT_KEY_PAIR.getPrivate());
        this.subject.validate("location", crl);
        this.result = this.subject.getValidationResult();
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "crl.next.update.before.now", new String[]{nextUpdateTime.toString()}), (Object)this.result.getResult(new ValidationLocation("location"), "crl.next.update.before.now"));
    }

    @Test
    public void shouldRejectWhenNextUpdateOutsideNegativeMaxStaleDays() {
        this.options = ValidationOptions.withStaleConfigurations((Duration)Duration.standardDays((long)-8L), (Duration)Duration.ZERO);
        this.subject = new X509CrlValidator(this.options, this.result, (AbstractX509CertificateWrapper)this.parent);
        ValidityPeriod newValidity = new ValidityPeriod((ReadableInstant)this.getRootCRL().getThisUpdateTime(), (ReadableInstant)UTC.dateTime().withMillisOfSecond(0));
        X509Crl crl = this.getRootCRL().withValidityPeriod(newValidity).build(ROOT_KEY_PAIR.getPrivate());
        this.subject.validate("location", crl);
        this.result = this.subject.getValidationResult();
        Assert.assertTrue((boolean)this.result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "crl.next.update.before.now", new String[]{newValidity.getNotValidAfter().toString()}), (Object)this.result.getResult(new ValidationLocation("location"), "crl.next.update.before.now"));
    }

    @Test
    public void shouldNotRejectWhenBetweenThisUpdateAndNextUpdate() {
        DateTime thisUpdateTime = UTC.dateTime().minusDays(1);
        DateTime nextUpdateTime = thisUpdateTime.plusDays(2);
        ValidityPeriod validity = new ValidityPeriod((ReadableInstant)thisUpdateTime, (ReadableInstant)nextUpdateTime);
        X509Crl crl = this.getRootCRL().withValidityPeriod(validity).build(ROOT_KEY_PAIR.getPrivate());
        this.subject.validate("location", crl);
        this.result = this.subject.getValidationResult();
        Assert.assertFalse((boolean)this.result.hasFailures());
    }

    private X509ResourceCertificate getRootResourceCertificate() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withSubjectDN(ROOT_CERTIFICATE_NAME);
        builder.withIssuerDN(ROOT_CERTIFICATE_NAME);
        builder.withSerial(ROOT_SERIAL_NUMBER);
        builder.withValidityPeriod(VALIDITY_PERIOD);
        builder.withPublicKey(ROOT_KEY_PAIR.getPublic());
        builder.withCa(true);
        builder.withKeyUsage(4);
        builder.withAuthorityKeyIdentifier(true);
        builder.withResources(ROOT_RESOURCE_SET);
        builder.withAuthorityKeyIdentifier(false);
        builder.withSigningKeyPair(ROOT_KEY_PAIR);
        return builder.build();
    }

    private X509CrlBuilder getRootCRL() {
        X509CrlBuilder builder = new X509CrlBuilder();
        builder.withIssuerDN(ROOT_CERTIFICATE_NAME);
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)VALIDITY_PERIOD.getNotValidBefore().plusDays(1), (ReadableInstant)UTC.dateTime().plusMonths(1)));
        builder.withNumber(BigInteger.valueOf(1L));
        builder.withAuthorityKeyIdentifier(ROOT_KEY_PAIR.getPublic());
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }

    static {
        DateTime now = UTC.dateTime();
        VALIDITY_PERIOD = new ValidityPeriod((ReadableInstant)now.minusDays(2), (ReadableInstant)now.plusDays(2));
        ROOT_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
        FIRST_CHILD_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
    }
}

