/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RoaPrefixTest {
    @Test
    public void shouldEqualWhenSemanticallyEqual() {
        new EqualsTester().addEqualityGroup(new Object[]{new RoaPrefix(IpRange.parse((String)"10.0.0.0/8")), new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), null), new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(8))}).addEqualityGroup(new Object[]{new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(32))}).addEqualityGroup(new Object[]{new RoaPrefix(IpRange.parse((String)"11.0.0.0/8")), new RoaPrefix(IpRange.parse((String)"11.0.0.0/8"), Integer.valueOf(8))});
    }

    @Test
    public void testCalculateEffectiveLength() {
        RoaPrefix p2 = new RoaPrefix(IpRange.parse((String)"11.0.0.0/8"));
        RoaPrefix p2_8 = new RoaPrefix(IpRange.parse((String)"11.0.0.0/8"), Integer.valueOf(8));
        RoaPrefix p2_32 = new RoaPrefix(IpRange.parse((String)"11.0.0.0/8"), Integer.valueOf(32));
        Assertions.assertThat((int)p2.getEffectiveMaximumLength()).isEqualTo(8);
        Assertions.assertThat((int)p2_8.getEffectiveMaximumLength()).isEqualTo(8);
        Assertions.assertThat((int)p2_32.getEffectiveMaximumLength()).isEqualTo(32);
    }

    @Test
    public void shouldSortRoaPrefixByPrefixThenMaximumLength() {
        RoaPrefix p1 = new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"));
        RoaPrefix p2 = new RoaPrefix(IpRange.parse((String)"11.0.0.0/8"));
        RoaPrefix p2_8 = new RoaPrefix(IpRange.parse((String)"11.0.0.0/8"), Integer.valueOf(8));
        RoaPrefix p2_24 = new RoaPrefix(IpRange.parse((String)"11.0.0.0/8"), Integer.valueOf(24));
        List<RoaPrefix> prefixList = List.of(p2_24, p1, p2_8, p2);
        ArrayList toSort = Lists.newArrayList(prefixList);
        Collections.sort(toSort);
        Assertions.assertThat((List)toSort).containsExactly((Object[])new RoaPrefix[]{p1, p2, p2_8, p2_24});
        Assertions.assertThat(new TreeSet<RoaPrefix>(prefixList)).hasSize(prefixList.size() - 1);
        for (int i = 0; i < 16; ++i) {
            toSort = Lists.newArrayList(prefixList);
            Collections.shuffle(toSort);
            Collections.sort(toSort);
            Assertions.assertThat((List)toSort).containsExactly((Object[])new RoaPrefix[]{p1, p2, p2_8, p2_24});
        }
    }

    @Test
    public void shouldEnsureIpAddressIsValidPrefix() {
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new RoaPrefix(IpRange.parse((String)"10.0.0.0-10.0.2.1"), null)).isInstanceOf(IllegalArgumentException.class)).withFailMessage("ROA prefix requires legal prefix", new Object[0]);
    }

    @Test
    public void shouldEnsureMaximumLengthValidity() {
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(-1))).isInstanceOf(IllegalArgumentException.class)).withFailMessage("maximum length invalid", new Object[0]);
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(8));
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(17));
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(32));
        new RoaPrefix(IpRange.parse((String)"ffe0::/16"), Integer.valueOf(128));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(0))).isInstanceOf(IllegalArgumentException.class)).withFailMessage("maximum length invalid", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(7))).isInstanceOf(IllegalArgumentException.class)).withFailMessage("maximum length invalid", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(33))).isInstanceOf(IllegalArgumentException.class)).withFailMessage("maximum length invalid", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new RoaPrefix(IpRange.parse((String)"ffe0::/16"), Integer.valueOf(129))).isInstanceOf(IllegalArgumentException.class)).withFailMessage("maximum length invalid", new Object[0]);
    }
}

