/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import java.io.IOException;
import java.math.BigInteger;
import net.ripe.rpki.commons.FixedDateRule;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsBuilder;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsParserTest;
import net.ripe.rpki.commons.crypto.util.Asn1UtilTest;
import org.bouncycastle.util.encoders.Hex;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ManifestCmsBuilderTest {
    @Rule
    public FixedDateRule fixedDateRule = new FixedDateRule(ManifestCmsParserTest.THIS_UPDATE_TIME);
    private ManifestCmsBuilder subject = new ManifestCmsBuilder();

    @Before
    public void setUp() {
        this.subject.withManifestNumber(BigInteger.valueOf(68L));
        this.subject.withValidityPeriod(new ValidityPeriod((ReadableInstant)ManifestCmsParserTest.THIS_UPDATE_TIME, (ReadableInstant)ManifestCmsParserTest.NEXT_UPDATE_TIME));
        this.subject.withCertificate(ManifestCmsParserTest.createValidManifestEECertificate());
        this.subject.withSignatureProvider("SunRsaSign");
    }

    @Test
    public void shouldTrackFilenameAndHash() {
        byte[] content = new byte[]{1, 2, 3, 4};
        this.subject.addFile("foo1", content);
        this.subject.addFile("foo3", content);
        ManifestCms result = this.subject.build(ManifestCmsParserTest.TEST_KEY_PAIR.getPrivate());
        Assert.assertTrue((boolean)this.subject.containsFile("foo1"));
        Assert.assertTrue((boolean)this.subject.containsFile("foo3"));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)result.getFiles().size());
        Assert.assertTrue((boolean)result.containsFile("foo1"));
        Assert.assertTrue((boolean)result.containsFile("foo3"));
        Assert.assertFalse((boolean)result.containsFile("abracadabra"));
    }

    @Test
    public void shouldCalculateHashAndWriteFile() throws IOException {
        byte[] contents = "contents".getBytes();
        this.subject.addFile("foo1", contents);
        ManifestCms result = this.subject.build(ManifestCmsParserTest.TEST_KEY_PAIR.getPrivate());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsFile("foo1"));
        byte[] expectedHash = Hex.decode((String)"d1b2a59fbea7e20077af9f91b27e95e865061b270be03ff539ab3b73587882e8");
        Assert.assertArrayEquals((byte[])expectedHash, (byte[])result.getHash("foo1"));
        Assert.assertTrue((boolean)result.verifyFileContents("foo1", contents));
        Assert.assertFalse((boolean)result.verifyFileContents("foo1", Hex.decode((String)"deadbeaf")));
    }

    @Test
    public void shouldEncodeFileAndHash() {
        Asn1UtilTest.assertEncoded(ManifestCmsParserTest.ENCODED_FILE_AND_HASH_1, this.subject.encodeFileAndHash("foo1", ManifestCmsParserTest.FOO_HASH));
    }

    @Test
    public void shouldEncodeEmptyFileList() {
        Asn1UtilTest.assertEncoded(ManifestCmsParserTest.ENCODED_EMPTY_FILE_LIST, this.subject.encodeFileList());
    }

    @Test
    public void shouldEncodeFileList() {
        this.subject.addFile("foo1", ManifestCmsParserTest.FOO_CONTENT);
        this.subject.addFile("BaR", ManifestCmsParserTest.BAR_CONTENT);
        Asn1UtilTest.assertEncoded(ManifestCmsParserTest.ENCODED_FILE_LIST, this.subject.encodeFileList());
    }

    @Test
    public void shouldEncodeManifest() {
        this.subject.addFile("foo1", ManifestCmsParserTest.FOO_CONTENT);
        this.subject.addFile("BaR", ManifestCmsParserTest.BAR_CONTENT);
        Assert.assertArrayEquals((byte[])ManifestCmsParserTest.ENCODED_MANIFEST, (byte[])this.subject.encodeManifest());
    }

    @Test
    public void shouldBeEquivalentToSetDateInDifferentWays() {
        ManifestCmsBuilder builder1 = new ManifestCmsBuilder();
        builder1.withManifestNumber(BigInteger.valueOf(68L));
        builder1.withThisUpdateTime(ManifestCmsParserTest.THIS_UPDATE_TIME);
        builder1.withNextUpdateTime(ManifestCmsParserTest.NEXT_UPDATE_TIME);
        builder1.withCertificate(ManifestCmsParserTest.createValidManifestEECertificate());
        builder1.withSignatureProvider("SunRsaSign");
        ManifestCmsBuilder builder2 = new ManifestCmsBuilder();
        builder2.withManifestNumber(BigInteger.valueOf(68L));
        builder2.withValidityPeriod(new ValidityPeriod((ReadableInstant)ManifestCmsParserTest.THIS_UPDATE_TIME, (ReadableInstant)ManifestCmsParserTest.NEXT_UPDATE_TIME));
        builder2.withNextUpdateTime(ManifestCmsParserTest.NEXT_UPDATE_TIME);
        builder2.withCertificate(ManifestCmsParserTest.createValidManifestEECertificate());
        builder2.withSignatureProvider("SunRsaSign");
        ManifestCms m1 = builder1.build(ManifestCmsParserTest.TEST_KEY_PAIR.getPrivate());
        ManifestCms m2 = builder1.build(ManifestCmsParserTest.TEST_KEY_PAIR.getPrivate());
        Assert.assertEquals((Object)m1.getThisUpdateTime(), (Object)m2.getThisUpdateTime());
        Assert.assertEquals((Object)m1.getNextUpdateTime(), (Object)m2.getNextUpdateTime());
    }
}

