/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.aspa;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import net.ripe.ipresource.Asn;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCms;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCmsParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class AspaCmsParserTest {
    AspaCmsParserTest() {
    }

    @Test
    void should_parse_draft15_aspa() throws IOException {
        AspaCms aspa = this.parseValidAspa("interop/aspa/GOOD-profile-15-draft-ietf-sidrops-profile-15-sample.asa");
        Assertions.assertThat((Comparable)aspa.getCustomerAsn()).isEqualTo((Object)Asn.parse((String)"AS15562"));
        Assertions.assertThat((int)aspa.getVersion()).isEqualTo(1);
        Assertions.assertThat((Collection)aspa.getProviderASSet()).containsExactly((Object[])new Asn[]{Asn.parse((String)"AS2914"), Asn.parse((String)"AS8283"), Asn.parse((String)"AS51088"), Asn.parse((String)"206238")});
    }

    @Test
    void should_parse_draft15_rpki_commons_object() throws IOException {
        AspaCms aspa = this.parseValidAspa("interop/aspa/GOOD-profile-15-rpki-commons-propertytest-sample.asa");
        Assertions.assertThat((int)aspa.getVersion()).isEqualTo(1);
    }

    @Test
    void should_accept_apnic_test_aspa_v1() throws IOException {
        AspaCms aspa = this.parseValidAspa("interop/aspa/GOOD-profile-15-APNIC-rpki-aspa-demo-AS1000.asa");
        Assertions.assertThat((Comparable)aspa.getCustomerAsn()).isEqualTo((Object)Asn.parse((String)"AS1000"));
        Assertions.assertThat((int)aspa.getVersion()).isEqualTo(1);
        Assertions.assertThat((Collection)aspa.getProviderASSet()).containsExactly((Object[])new Asn[]{Asn.parse((String)"AS1025")});
    }

    @Test
    void should_reject_draft15_rpki_commons_with_implicit_tag() throws IOException {
        AspaCmsParser parser = new AspaCmsParser();
        ValidationResult result = ValidationResult.withLocation((String)"BAD-profile-15-rpki-commons-propertytest-sample-implicit-tag.asa");
        parser.parse(result, Resources.toByteArray((URL)Resources.getResource((String)"interop/aspa/BAD-profile-15-rpki-commons-propertytest-sample-implicit-tag.asa")));
        Assertions.assertThat((boolean)result.hasFailures()).isTrue();
        Assertions.assertThat((List)result.getFailuresForAllLocations()).anyMatch(check -> "aspa.content.structure".equals(check.getKey()));
    }

    @Test
    void should_reject_apnic_test_aspa_WRONG_VERSION() throws IOException {
        AspaCmsParser parser = new AspaCmsParser();
        ValidationResult result = ValidationResult.withLocation((String)"BAD-profile-15-APNIC-rpki-aspa-demo-AS1000.asa");
        parser.parse(result, Resources.toByteArray((URL)Resources.getResource((String)"interop/aspa/BAD-profile-15-APNIC-rpki-aspa-demo-AS1000.asa")));
        Assertions.assertThat((boolean)result.hasFailures()).isTrue();
        Assertions.assertThat((List)result.getFailuresForAllLocations()).anyMatch(check -> "aspa.version".equals(check.getKey()));
    }

    @Test
    void parseAspa_wrong_profile_version() throws IOException {
        AspaCmsParser parser = new AspaCmsParser();
        ValidationResult result = ValidationResult.withLocation((String)"BAD-profile-13-AS211321-profile-13.asa");
        parser.parse(result, Resources.toByteArray((URL)Resources.getResource((String)"interop/aspa/BAD-profile-13-AS211321-profile-13.asa")));
        Assertions.assertThat((boolean)result.hasFailures()).isTrue();
        Assertions.assertThat((List)result.getFailuresForAllLocations()).allMatch(check -> "aspa.version".equals(check.getKey()));
    }

    private AspaCms parseValidAspa(String path) throws IOException {
        byte[] bytes = Resources.toByteArray((URL)Resources.getResource((String)path));
        ValidationResult result = ValidationResult.withLocation((String)path);
        AspaCmsParser parser = new AspaCmsParser();
        parser.parse(result, bytes);
        ((ListAssert)Assertions.assertThat((List)result.getFailuresForAllLocations()).withFailMessage(() -> "" + result.getFailuresForAllLocations())).isEmpty();
        AspaCms aspa = parser.getAspa();
        return aspa;
    }

    @Test
    void parseAspa_wrong_file_type() throws IOException {
        AspaCmsParser parser = new AspaCmsParser();
        ValidationResult result = ValidationResult.withLocation((String)"goodROAASIDZero.roa");
        parser.parse(result, Resources.toByteArray((URL)Resources.getResource((String)"conformance/root/goodROAASIDZero.roa")));
        Assertions.assertThat((boolean)result.hasFailures()).isTrue();
        Assertions.assertThat((List)result.getFailuresForAllLocations()).anyMatch(check -> "aspa.content.type".equals(check.getKey()));
    }
}

