/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.util;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.commons.lang3.Validate;

public class VersionedId
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long INITIAL_VERSION = -1L;
    private final long id;
    private final long version;

    public VersionedId(long id) {
        this(id, -1L);
    }

    public VersionedId(long id, long version) {
        this.id = id;
        this.version = version;
    }

    public long getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionedId other = (VersionedId)obj;
        if (this.id != other.id) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return this.id + ":" + this.version;
    }

    public static VersionedId parse(String s) {
        Validate.notNull((Object)s, (String)"string required", (Object[])new Object[0]);
        StringTokenizer tokenizer = new StringTokenizer(s, ":");
        int count = tokenizer.countTokens();
        Validate.isTrue((count == 1 || count == 2 ? 1 : 0) != 0, (String)"invalid number of tokens in versioned id", (Object[])new Object[0]);
        try {
            long id = Long.parseLong(tokenizer.nextToken());
            long version = tokenizer.hasMoreTokens() ? Long.parseLong(tokenizer.nextToken()) : 0L;
            return new VersionedId(id, version);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("versioned id can not be parsed from " + s);
        }
    }
}

