/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.rfc3779;

import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import net.ripe.ipresource.ImmutableResourceSet;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import org.apache.commons.lang3.Validate;

public final class ResourceExtension
implements Serializable {
    private static final ImmutableResourceSet[] RESOURCES_BY_TYPE = new ImmutableResourceSet[IpResourceType.values().length];
    @NonNull
    private final EnumSet<IpResourceType> inheritedResourceTypes;
    @NonNull
    private final ImmutableResourceSet resources;

    private ResourceExtension(@NonNull EnumSet<IpResourceType> inheritedResourceTypes, @NonNull ImmutableResourceSet resources) {
        if (inheritedResourceTypes == null) {
            throw new NullPointerException("inheritedResourceTypes is marked non-null but is null");
        }
        if (resources == null) {
            throw new NullPointerException("resources is marked non-null but is null");
        }
        Validate.isTrue((!inheritedResourceTypes.isEmpty() || !resources.isEmpty() ? 1 : 0) != 0, (String)"empty resource extension", (Object[])new Object[0]);
        for (IpResourceType inheritedResourceType : inheritedResourceTypes) {
            if (!resources.containsType(inheritedResourceType)) continue;
            throw new IllegalArgumentException("resources overlap with inherited resource type " + inheritedResourceType);
        }
        this.inheritedResourceTypes = inheritedResourceTypes;
        this.resources = resources;
    }

    public EnumSet<IpResourceType> getInheritedResourceTypes() {
        return EnumSet.copyOf(this.inheritedResourceTypes);
    }

    public static ResourceExtension of(EnumSet<IpResourceType> inheritedResourceTypes, ImmutableResourceSet resources) {
        return new ResourceExtension(EnumSet.copyOf(inheritedResourceTypes), resources);
    }

    public static ResourceExtension ofResources(ImmutableResourceSet resources) {
        return new ResourceExtension(EnumSet.noneOf(IpResourceType.class), resources);
    }

    public static ResourceExtension ofInherited(EnumSet<IpResourceType> inheritedResourceTypes) {
        return new ResourceExtension(EnumSet.copyOf(inheritedResourceTypes), ImmutableResourceSet.empty());
    }

    public static ResourceExtension allInherited() {
        return new ResourceExtension(EnumSet.allOf(IpResourceType.class), ImmutableResourceSet.empty());
    }

    public ResourceExtension withInheritedResourceTypes(EnumSet<IpResourceType> inheritedResourceTypes) {
        return new ResourceExtension(EnumSet.copyOf(inheritedResourceTypes), this.resources);
    }

    public ResourceExtension withResources(ImmutableResourceSet resources) {
        return new ResourceExtension(this.inheritedResourceTypes, resources);
    }

    public Optional<ResourceExtension> mapResources(UnaryOperator<ImmutableResourceSet> mapper) {
        ImmutableResourceSet updatedResources = (ImmutableResourceSet)mapper.apply(this.resources);
        return this.inheritedResourceTypes.isEmpty() && updatedResources.isEmpty() ? Optional.empty() : Optional.of(new ResourceExtension(this.inheritedResourceTypes, updatedResources));
    }

    public ImmutableResourceSet deriveResources(ImmutableResourceSet parentResources) {
        if (this.inheritedResourceTypes.isEmpty()) {
            return this.resources;
        }
        if (this.inheritedResourceTypes.containsAll(EnumSet.allOf(IpResourceType.class))) {
            return parentResources;
        }
        ImmutableResourceSet result = this.resources;
        for (IpResourceType type : this.inheritedResourceTypes) {
            result = result.union(parentResources.intersection(RESOURCES_BY_TYPE[type.ordinal()]));
        }
        return result;
    }

    public boolean isResourceTypesInherited(Collection<IpResourceType> resourceTypes) {
        return this.inheritedResourceTypes.containsAll(resourceTypes);
    }

    public boolean isResourceSetInherited() {
        return !this.inheritedResourceTypes.isEmpty();
    }

    public boolean containsResources(IpResourceSet that) {
        return this.resources.contains((Iterable)that);
    }

    public boolean containsResources(ImmutableResourceSet that) {
        return this.resources.contains((Iterable)that);
    }

    @NonNull
    public ImmutableResourceSet getResources() {
        return this.resources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceExtension)) {
            return false;
        }
        ResourceExtension other = (ResourceExtension)o;
        EnumSet<IpResourceType> this$inheritedResourceTypes = this.getInheritedResourceTypes();
        EnumSet<IpResourceType> other$inheritedResourceTypes = other.getInheritedResourceTypes();
        if (this$inheritedResourceTypes == null ? other$inheritedResourceTypes != null : !((Object)this$inheritedResourceTypes).equals(other$inheritedResourceTypes)) {
            return false;
        }
        ImmutableResourceSet this$resources = this.getResources();
        ImmutableResourceSet other$resources = other.getResources();
        return !(this$resources == null ? other$resources != null : !this$resources.equals(other$resources));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnumSet<IpResourceType> $inheritedResourceTypes = this.getInheritedResourceTypes();
        result = result * 59 + ($inheritedResourceTypes == null ? 43 : ((Object)$inheritedResourceTypes).hashCode());
        ImmutableResourceSet $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceExtension(inheritedResourceTypes=" + this.getInheritedResourceTypes() + ", resources=" + this.getResources() + ")";
    }

    static {
        for (IpResourceType type : IpResourceType.values()) {
            ResourceExtension.RESOURCES_BY_TYPE[type.ordinal()] = ImmutableResourceSet.of((IpResource)type.getMinimum().upTo(type.getMaximum()));
        }
    }
}

