/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.CheckForNull;
import net.ripe.ipresource.IpRange;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class RoaPrefix
implements Serializable,
Comparable<RoaPrefix> {
    private static final Comparator<RoaPrefix> ROA_PREFIX_COMPARATOR = Comparator.comparing(RoaPrefix::getPrefix).thenComparing(RoaPrefix::getMaximumLength, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final long serialVersionUID = 1L;
    private final IpRange prefix;
    @CheckForNull
    private final Integer maximumLength;

    public RoaPrefix(IpRange prefix) {
        this(prefix, null);
    }

    public RoaPrefix(IpRange prefix, Integer maximumLength) {
        Validate.notNull((Object)prefix, (String)"prefix is required", (Object[])new Object[0]);
        Validate.isTrue((boolean)prefix.isLegalPrefix(), (String)"prefix is not a legal prefix", (Object[])new Object[0]);
        Validate.isTrue((maximumLength == null || maximumLength >= prefix.getPrefixLength() && maximumLength <= prefix.getType().getBitSize() ? 1 : 0) != 0, (String)"maximum length not in range", (Object[])new Object[0]);
        this.prefix = prefix;
        this.maximumLength = maximumLength;
    }

    public IpRange getPrefix() {
        return this.prefix;
    }

    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    public int getEffectiveMaximumLength() {
        return this.maximumLength != null ? this.maximumLength.intValue() : this.getPrefix().getPrefixLength();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("prefix", (Object)this.getPrefix()).append("maximumLength", (Object)this.maximumLength).toString();
    }

    @Override
    public int compareTo(RoaPrefix o) {
        return ROA_PREFIX_COMPARATOR.compare(this, o);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoaPrefix)) {
            return false;
        }
        RoaPrefix other = (RoaPrefix)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maximumLength = this.getMaximumLength();
        Integer other$maximumLength = other.getMaximumLength();
        if (this$maximumLength == null ? other$maximumLength != null : !((Object)this$maximumLength).equals(other$maximumLength)) {
            return false;
        }
        IpRange this$prefix = this.getPrefix();
        IpRange other$prefix = other.getPrefix();
        return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoaPrefix;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maximumLength = this.getMaximumLength();
        result = result * 59 + ($maximumLength == null ? 43 : ((Object)$maximumLength).hashCode());
        IpRange $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        return result;
    }
}

