/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.security.PrivateKey;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectBuilder;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.util.Asn1Util;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;

public class RoaCmsBuilder
extends RpkiSignedObjectBuilder {
    private X509ResourceCertificate certificate;
    private Asn asn;
    private List<RoaPrefix> prefixes;
    private String signatureProvider;

    public RoaCmsBuilder withCertificate(X509ResourceCertificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public RoaCmsBuilder withAsn(Asn asn) {
        this.asn = asn;
        return this;
    }

    public RoaCmsBuilder withPrefixes(List<RoaPrefix> prefixes) {
        this.prefixes = prefixes;
        return this;
    }

    public RoaCmsBuilder withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public RoaCms build(PrivateKey privateKey) {
        String location = "unknown.roa";
        RoaCmsParser parser = new RoaCmsParser();
        parser.parse(ValidationResult.withLocation(location), this.generateCms(this.certificate.getCertificate(), privateKey, this.signatureProvider, RoaCms.CONTENT_TYPE, this.encodeRouteOriginAttestation(this.asn, this.prefixes)));
        return parser.getRoaCms();
    }

    ASN1Object encodeRoaIpAddress(RoaPrefix prefix) {
        DERBitString address = Asn1Util.resourceToBitString(prefix.getPrefix().getStart(), prefix.getPrefix().getPrefixLength());
        ASN1Encodable[] encodables = prefix.getMaximumLength() == null ? new ASN1Encodable[]{address} : new ASN1Encodable[]{address, new ASN1Integer((long)prefix.getMaximumLength().intValue())};
        return new DERSequence(encodables);
    }

    ASN1Encodable encodeRoaIpAddressFamily(AddressFamily addressFamily, Set<RoaPrefix> prefixes) {
        Validate.isTrue((addressFamily == AddressFamily.IPV4 || addressFamily == AddressFamily.IPV6 ? 1 : 0) != 0, (String)"ROA can only contain IPv4 or IPv6 AFI", (Object[])new Object[0]);
        ASN1Encodable[] encodablePrefixes = (ASN1Encodable[])prefixes.stream().sorted().map(this::encodeRoaIpAddress).toArray(ASN1Encodable[]::new);
        ASN1Encodable[] seq = new ASN1Encodable[]{addressFamily.toDer(), new DERSequence(encodablePrefixes)};
        return new DERSequence(seq);
    }

    ASN1Encodable encodeRoaIpAddressFamilySequence(List<RoaPrefix> prefixes) {
        Validate.isTrue((!prefixes.isEmpty() ? 1 : 0) != 0, (String)"no prefixes", (Object[])new Object[0]);
        List<ASN1Encodable> encodables = Stream.concat(this.addRoaIpAddressFamily(IpResourceType.IPv4, prefixes), this.addRoaIpAddressFamily(IpResourceType.IPv6, prefixes)).collect(Collectors.toList());
        Validate.isTrue((!encodables.isEmpty() ? 1 : 0) != 0, (String)"no encodable prefixes", (Object[])new Object[0]);
        return new DERSequence(encodables.toArray(new ASN1Encodable[encodables.size()]));
    }

    private Stream<ASN1Encodable> addRoaIpAddressFamily(IpResourceType type, List<RoaPrefix> prefixes) {
        Set<RoaPrefix> selectedPrefixes = prefixes.stream().filter(roaPrefix -> type == roaPrefix.getPrefix().getType()).collect(Collectors.toSet());
        if (selectedPrefixes.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.encodeRoaIpAddressFamily(AddressFamily.fromIpResourceType(type), selectedPrefixes));
    }

    byte[] encodeRouteOriginAttestation(Asn asn, List<RoaPrefix> prefixes) {
        ASN1Encodable[] encodables = new ASN1Encodable[]{new ASN1Integer(asn.getValue()), this.encodeRoaIpAddressFamilySequence(prefixes)};
        return Asn1Util.encode((ASN1Encodable)new DERSequence(encodables));
    }
}

